
## 4.2. Finding Diverse Plan Set With Lpg

In this section, we consider the problem of generating diverse set of plans using another planning approach, in particular the LPG planner which is able to scale up to bigger problems, compared to GP-CSP. We focus on the action-based distance measure between plans, which has been shown in the previous section to be the most difficult to enforce diversity. LPG is a local-search-based planner, that incrementally modifies a partial plan in a search for a plan that contains no flaws (Gerevini et al., 2003). The behavior of LPG is controlled by an evaluation function that is used to select between different plan candidates in a neighborhood generated for local search. At each search step, the elements in the search neighborhood of the current partial plan π are the alternative possible plans repairing a selected flaw in π. The elements of the neighborhood are evaluated according to an *action evaluation function* E (Gerevini et al., 2003). This function is used to estimate the cost of either adding or of removing an action node a in the partial plan p being generated.

4.2.1. Revised Evaluation Function for Diverse Plans In order to manage dDISTANCEkSET problems, the function E has been extended to include an additional evaluation term that has the purpose of penalizing the insertion and removal of actions that *decrease* the distance of the current partial plan p under adaptation from a reference plan p0. In general, E consists of four weighted terms, evaluating four aspects of the quality of the current plan that are affected by the addition (E(a)
i) or removal (E(a)
r) of a

$E(a)^{i}=\alpha_{E}\cdot Execution\_cost(a)^{i}+\alpha_{T}\cdot Temporal\_cost(a)^{i}+$  $$+\alpha_{S}\cdot Search\_cost(a)^{i}+\alpha_{D}\cdot|(p_{0}-p)\cap p_{0}^{i}|$$  $E(a)^{r}=\alpha_{E}\cdot Execution\_cost(a)^{r}+\alpha_{T}\cdot Temporal\_cost(a)^{r}+$  $$+\alpha_{S}\cdot Search\_cost(a)^{r}+\alpha_{D}\cdot|(p_{0}-p-a)\cap p_{0}^{r}|.$$
The first three terms of the two forms of E are unchanged from the standard behavior of LPG. The fourth term, used only for computing diverse plans, is the new term estimating how the proposed plan modification will affect the distance from the reference plan p0. Each cost term in E is computed using a relaxed temporal plan pR (Gerevini et al., 2003).

The pR plans are computed by an algorithm, called RelaxedPlan, formally described and illustrated in Gerevini et al. (2003). We have slightly modified this algorithm to penalize the selection of actions decreasing the plan distance from the reference plan. The specific change to RelaxedPlan for computing diverse plans is very similar to the change described in (Fox et al., 2006), and it concerns the heuristic function for selecting the actions for achieving the subgoals in the relaxed plans. In the modified function for RelaxedPlan, we have an extra 0/1 term that penalizes an action b for pR if its addition decreases the distance of p + pR from p0 (in the plan repair context investigated in (Fox et al., 2006), b is penalized if its addition *increases* such a distance).

The last term of the modified evaluation function E is a measure of the decrease in plan distance caused by adding or removing a: |(p0−p)∩p i R| or |(p0−p−a)∩p r R|, where p i R contains the new action a. The α-coefficients of the E-terms are used to weigh their relative importance.11