and as a result the web service engine wants to have a set of diverse plans/compositions such that if there is a failure while executing one composition, an alternative may be used which is less likely to be failing simultaneously (Chafle et al., 2006). However, if a user is helping in selecting the compositions, the planner could be first asked for a set of plans that may take into account the user's trust in some particular sources and when she selects one of them, it is next asked to find plans that are similar to the selected one. The requirement of searching for a set of plans is also considered in intrusion detection (Boddy et al., 2005) where a security analysis needs to analyze a set of attack plans that might be attempted by a potential adversary, given limited (or unknown)
information about the adversary's model (e.g., his goals, capabilities, habits, ...), and the resulting analyzed information can then be used to set up defensive strategies against potential attacks in the future. Another example can be found in Memon et al. (2001) in which test cases for graphical user interfaces (GUIs) are generated as a set of distinct plans, each corresponding to a sequence of actions that a user could perform, given the user's unknown preferences on how to interact with the GUI to achieve her goals. The capability of synthesizing multiple plans would also have potential application in case-based planning (e.g., Serina (2010)) where it is important to have a plan set satisfying a case instance. These plans can be different in terms of criteria such as resources, makespan and cost that can only be specified in the retrieval phase. In the problem of travel planning for individuals of a city in a distributed manner while also optimizing public resource (e.g., road, traffic police personel), the availability of a number of plans for each person's goals could make the plan merging phase easier and reduce the conflicts among individual plans.

In this work, we investigate the problem of generating *a set of plans* in order to deal with planning situations where the preference model is not completely specified. In particular, we consider the following scenarios:
- Even though the planner is aware that the user has some preferences on solution plans, it is not provided with any of that knowledge.

- The planner is provided with incomplete knowledge of the user's preferences. In particular, the user is interested in some plan *attributes* (such as the duration and cost of a flight, or whether all packages with priority are delivered on time in a logistic domain), each with different but unknown degree of importance (represented by weight or *trade-off* values).

Normally, it is quite hard for a user to indicate the exact trade-off values, but instead more likely to determine that one attribute is more (or less) important than some others—for instance, a bussinessman would consider the duration of a flight much more important than its cost. Such kind of incomplete preference specification could be modeled with a probability distribution of weights values2, and is therefore assumed to be given as an input
(together with the attributes) to the planner.
Even though, in principle, the user would have a better chance to find her desired plan from a larger plan set, there are two problems to consider—one computational, and other comprehensional. The computational problem is that synthesis of a single plan is often quite costly already, and therefore it is even more challenging to search for a large plan set. Coming to the second problem, it is unclear that the user will be able to inspect a large set of plans to identify the plan