# Extracting Features From Ratings: The Role Of Factor Models Joachim Selke And Wolf-Tilo Balke1

Abstract. Performing effective preference-based data retrieval requires detailed and preferentially meaningful structurized information about the current user as well as the items under consideration. A common problem is that representations of items often only consist of mere technical attributes, which do not resemble human perception. This is particularly true for integral items such as movies or songs. It is often claimed that meaningful item features could be extracted from collaborative rating data, which is becoming available through social networking services. However, there is only anecdotal evidence supporting this claim; but if it is true, the extracted information could very valuable for preference-based data retrieval. In this paper, we propose a methodology to systematically check this common claim. We performed a preliminary investigation on a large collection of movie ratings and present initial evidence.

## 1 Introduction

Recommender systems [1, 17] are one of the most prominent applications of preference handling technology [6] and a highly active area of research. In particular, fueled by the Netflix competition and its one million dollar prize money [2], research on collaborative recommendation techniques [21] has recently made significant advances, most notably through the introduction of *factor models* [16, 22].

In collaborative recommender systems, *users* repeatedly express their preferences for *items*, which usually is done by giving explicit ratings on some predefined numerical scale. This data can be modeled using a *rating matrix,* whose rows correspond to items, columns to users, and entries to ratings. Typically, ratings matrices are very sparse, that is, only a small fraction of all possible ratings have actually been observed. Personalized recommendations are generated by predicting unobserved ratings from the available data and, for each user, selecting those items considered to be most appealing.

Most state-of-the-art collaborative recommendation methodsincluding the winner of the Netflix Prize—are based on factor models, which are known to yield much more accurate predictions than traditional neighborhood-based methods [14, 15, 22, 23, 24]. In factor models, each user and each item is represented by a vector in some shared real coordinate space. The vectors are chosen such that each observed rating is closely approximated by the dot product of the corresponding item and user vectors. The selection of coordinates usually is formalized as an optimization problem. Predictions for unobserved ratings are generated by computing the respective scalar products. Equivalently, this approach can be seen as a factorization of the rating matrix into the product of an item matrix (whose rows 1Institut für Informationssysteme, Technische Universität Braunschweig, Germany are the item vectors) and a user matrix (whose columns are the user vectors).

The success of factor models is usually attributed to the intuition that the coordinate space used to represent items and users actually is a *latent feature space*. That is, its dimensions capture the items' perceptual properties as well as the users' preference judgments regarding these properties. For example, when items are movies, the individual dimensions are generally thought to measure (more of less)
"obvious" features such as horror vs. romance, the level of sophistication, or orientation towards adults. For users, each coordinate is thought to describe the relative degree of importance attached to the respective dimension. This understanding of factor models can be found throughout the literature, for example, in [2, 15, 16, 18, 23].

Although it is intuively appealing, to our knowledge, the correspondence to features has never been systematically proven, but is only reported anecdotically. For example, Koren et al. [16] performed a factorization on the Netflix movie data set and manually interpreted the first two coordinates for selected movies as follows:
Someone familiar with the movies shown can see clear meaning in the latent factors. The first factor has on one side lowbrow comedies and horror movies, aimed at a male or adolescent audience, while the other side contains drama or comedy with serious undertones and strong female leads. The second factorization axis has independent, critically acclaimed, quirky films on the top, and on the bottom, mainstream formulaic films.

Further evidence has been provided by Takács et al. [23]. After performing a factorization of the Netflix data set, they manually assigned labels to individual dimensions of their coordinate space, such as *Legendary, Typical for men, Romantic,* and *NOT Monty Python*.

In this paper, we propose a *systematic* method for studying the coordinate spaces derived from factor models and apply it the MovieLens 10M data set, a large real-world collection of movie ratings. The main contribution of our work consists in laying important groundwork, on which further research in recommender systems and preference handling can be build. In particular, we see two concrete directions for future work:
- First, knowing what kind of semantic information is extracted by factor models—and how it is represented in coordinate spaceswill enable a deeper understanding of these methods. Ultimately, these findings may lead to a more systematic development and refinement of recommender systems. In particular, a systematic assessment of semantic structures provides an additional way of evaluating the effectiveness of factor-based recommenders. This would perfectly complement traditional evaluation methods [11],
which focus on predictive accuracy.