For a start, we selected two popular classification algorithms, which are able to detect different kinds of patterns in the data: support vector machines and kNN-classifiers.

Support vector machines will be used in two different flavors: first, using a linear kernel (refered to as SVM-lin), and second, using a Gaussian radial basis function kernel (SVM-RBF). Linear support vector machines will show a high classification accuracy if most movies of the respective genre are grouped at one side of the data set, which can be separated from all remaining movies by a hyperplane.

For example, this can be used to disprove the hypothesis that there exists a direction in the coordinate space along which, say, the amount of action, increases monotonically. In contrast, the SVM-RBF classifier detects whether groups of movies with the same genre tend to be located in close vincinity.

kNN-classifiers perform well if the distance between movies having the same genre typically is smaller than the distance to movies not having this genre. Therefore, they can be used to check whether genres form spatially separated patterns in coordinate space. Since factor models are not based on a notion of proximity, it is not clear what measure of distance suits factor models best. We will try out the following four measures: Euclidean distance, standardized Euclidean distance (where, to ensure equally weighted dimensions, coordinate values are divided by the standard deviation of the data with respect each dimension), negative scalar product (which essentially adapts the method of rating prediction to measure distance), and cosine similarity (which is monotonically related to the angle between two vectors).

To evaluate the true benefit of coordinate spaces generated from factor models, we propose the following baseline, which is derived from traditional neighborhood-based recommendation methods [20]
and constructed as follows: First, for any items i and j, we compute their Pearson correlation coefficient

$$\varrho_{i,j}=\frac{\sum_{u\in\mathcal{R}_{i,j}}(r_{i,u}-\mu_{i,j})(r_{j,u}-\mu_{j,i})}{\sqrt{\sum_{u\in\mathcal{R}_{i,j}}(r_{i,u}-\mu_{i,j})^{2}}\sqrt{\sum_{u\in\mathcal{R}_{i,j}}(r_{j,u}-\mu_{j,i})^{2}}},$$
,
where Ri,j is the set of all users who rated both i and j, and µi,j is the mean rating given to item i by users who rated both i and j. If Ri,j is empty, then ̺i,j is undefined. The Pearson correlation coefficient ̺i,j measures the tendency of users to rate items i and j similarly. To avoid biased estimates in cases where ni,j = |Ri,j | is very small, we derive a new measure of similarity

$$s_{i,j}={\frac{n_{i,j}}{n_{i,j}+\lambda}}\cdot\varrho_{i,j}$$

from ̺i,j by shrinking towards zero [15]. Here, λ ≥ 0 is a regularization parameter. Finally, we carry over these similarity into distances by applying a logarithmic transformation:

$$d_{i,j}=-\ln\left({\frac{1+s_{i,j}}{2}}\right).$$

To derive a d-dimensional coordinate space in which items i and j approximately have distance di,j , we use metric multidimensional scaling [4]. Since neighborhood-based recommendation methods are usually outperformed by factor models, we expect our baseline coordinate space to be far inferior to those constructed using factor models. We refer to our baseline model as MDS.

## 4 Experiments On Movielens 10M

We applied our approach to the MovieLens 10M data set 7, which consists of about 10 million ratings collected by the online movie recommender service MovieLens8. After postprocessing the original data (removing one non-existing movie, merging several duplicate movie entries, and removing movies that received less than 20 ratings), our new data set consists of 9,984,419 ratings of 8938 movies provided by 69878 users. The ratings use a 10-point scale from 0.5
(worst) to 5 (best). Each user contributed at least 14 ratings.

Our analysis requires the genre information maintained by IMDb, so we had to map each movie in the data set to its corresponding IMDb entry. This task has been simplified a lot by the fact that all items in the MovieLens 10M data set are relatively well-known movies developed for cinema.9 We mapped about 8000 movies automatically by comparing titles and release years; the remaining movies have been assigned manually or semi-automatically.

To avoid the problem of learning from very small samples for now, we did not use all 28 genres distinguished by IMDb. Instead, we take only those genres into consideration that have been assigned to at least 5% of all movies in our data set. Table 1 lists all remaining 13 genres and their relative frequencies. On average, 2.3 genres have been assigned to each movie.

| Genre     | %                               | Genre    | %    |
|-----------|---------------------------------|----------|------|
| Action    | 16.0                            | Horror   | 10.1 |
| Adventure | 12.7                            | Mystery  | 9.1  |
| Comedy    | 38.2                            | Romance  | 25.2 |
| Crime     | 16.6                            | Sci-Fi   | 8.6  |
| Drama     | 54.6                            | Thriller | 24.2 |
| Family    | 8.4                             | War      | 5.2  |
| Fantasy   | 8.3                             |          |      |
| Table 1.  | Relative frequencies of genres. |          |      |

## 4.1 Generating Coordinate Spaces

We implemented each of the four coordinate extraction methods in MATLAB and executed them on our rating data.

For SVD, δ-SVD, and NNMF, we followed the literature and used an optimization procedure based on gradient descent; to reduce computation time, we applied the Hessian speedup proposed in [19].

Adapting the common methodology, we chose the regularization parameter λ by cross-validation such that the SSE is minimized on randomly chosen test sets. We ended up with a value of λ = 0.04 for each of the three algorithms.

Since optimization by gradient descent is known to get stuck in local extrema of the function to be minimized, we ran the three procedures at least three times, each with different initial coordinates, which have been chosen randomly. For each result, we computed the standardized solution pair as described in the previous section. We found that the solutions generated by each extractor do not differ significantly after standardization. This indicates that our coordinate spaces match the unique solution of each optimization problem.

For our MDS procedure, we used the regularization constant λ =
20, which we determined by adapting the recommendation Koren 7 http://www.grouplens.org/node/73 8 http://www.movielens.org 9 This is the reason why we did not consider the Netflix data set. It consists of all kinds of DVD titles, which often lack a clear correspondence in IMDb.