- The coordinate space derived by NNMF does not contain much helpful information about genres that can be exploited by our classifiers. The performance in all other spaces is significantly better.

- Except for NN-sEucl, classification performance generally improves with increasing dimensionality. However, the difference in performance between d **= 10** and d **= 50** is much larger than the one between d **= 50** and d **= 100**. This indicates that our ordering of dimensions during standardization indeed captures some notion of relative importance. This is probably also the reason for NN-sEucl's decreasing performance with growing d; treating all dimensions equally seems to overweight information from dimensions at the end of the list.

- The SVM-RBF classifier slightly outperforms SVM-lin, but is comparable in performance to 9NN-Eucl, 9NN-scal, and 9NNcos. This indicates that genres indeed tend to cluster in coordinate spaces, even with respect to different measures of distance.

- The NN-classifiers display bad performance for k = 1 and k = 3, which indicates that, although movies of the same genre roughly occur in clusters, each cluster usually also contains movies that do not have assigned the respective genre.

- In contrast to our expectations, the performance in coordinate spaces generated by factor models is comparable to the performance shown on our baseline coordinate space MDS.

Moreover, the results suggest that the performance of kNNclassifiers might even further increase for larger values of k. To check this, we performed some preliminary tests with k ≈ 20, but have not been able to confirm this conjective.

We also investigated the influence of individual genres on classification performance; as an example, the results for SVM-RBF are reported in Table 6. Entries larger than 0.20 have been indicated. We can see that some genres, such as *Horror* and *Drama*, can clearly be identified by the classifier, while others cannot. We have expected much better performance on clear-cut genres such as *War.*

| SVD-100   | δ-SVD-100                    | NNMF-100   | MDS-100   |      |
|-----------|------------------------------|------------|-----------|------|
| Action    | 0.34                         | 0.31       | 0.22      | 0.22 |
| Adventure | 0.13                         | 0.12       | 0.08      | 0.00 |
| Comedy    | 0.45                         | 0.42       | 0.25      | 0.42 |
| Crime     | 0.08                         | 0.06       | −0.01     | 0.00 |
| Drama     | 0.47                         | 0.43       | 0.37      | 0.44 |
| Family    | 0.43                         | 0.46       | 0.31      | 0.34 |
| Fantasy   | 0.03                         | 0.05       | 0.01      | 0.00 |
| Horror    | 0.56                         | 0.54       | 0.31      | 0.61 |
| Mystery   | 0.06                         | 0.04       | −0.00     | 0.00 |
| Romance   | 0.11                         | 0.10       | −0.00     | 0.00 |
| Sci-Fi    | 0.23                         | 0.20       | 0.09      | 0.00 |
| Thriller  | 0.31                         | 0.27       | 0.14      | 0.15 |
| War       | 0.05                         | 0.06       | −0.00     | 0.00 |
| Table 6.  | Kappas for SVM-RBF by genre. |            |           |      |

In summary, these preliminary experiments suggest that the coordinate spaces derived by SVD, δ-SVD, and MDS indeed contain some significant semantic information about the represented movies.

However, the situation is by far not as clear as claimed by the literature.

## 5 Conclusion And Outlook

In the current paper, we presented a general methodology for systematically analyzing whether coordinate spaces generated from factor models contain semantic information, as it is commonly claimed.

We applied our approach to the MovieLens 10M data set and found initial evidence for this claim.

Our results encourage us to follow this line of research in several ways. First, we would like to investigate whether our results also carry over to more advanced and complex factor models, which have been proposed very recently [13, 15]. It would also interesting to see what more traditional methods such as multidimensional scaling can contribute to the problem of feature extraction from rating data, since our results indicate that these methods can sucessfully be modified for use in our new setting.

## References

[1] Gediminas Adomavicius and Alexander Tuzhilin, 'Toward the next generation of recommender systems: A survey of the state-of-the-art and possible extensions', *IEEE Transactions on Knowledge and Data Engineering*, 17(6), 734–749, (2005).

[2] Robert M. Bell, Jim Bennett, Yehuda Koren, and Chris Volinsky,
'The million dollar programming prize', *IEEE Spectrum*, 46(5), 28–33,
(2009).

[3] Robert M. Bell and Yehuda Koren, 'Scalable collaborative filtering with jointly derived neighborhood interpolation weights', in *Proceedings of* ICDM 2007, pp. 43–52. IEEE Computer Society, (2007).

[4] Ingwer Borg and Patrick J. F. Groenen, *Modern Multidimensional Scaling: Theory and Applications*, Springer, second edn., 2005. [5] Craig Boutilier, Kevin Regan, and Paolo Viappiani, 'Preference elicitation with subjective features', in *Proceedings of RecSys 2009*, pp. 341–
344. ACM, (2009).

[6] Ronen I. Brafman and Carmel Domshlak, 'Preference handling: An introductory tutorial', *AI Magazine*, 30(1), 58–86, (2009).

[7] Zlatko Drmac, 'Accurate computation of the product-induced singular ˇ
value decomposition with applications', SIAM Journal on Numerical Analysis, 35(5), 1969–1994, (1998).

[8] Peter Enser and Christine Sandom, 'Towards a comprehensive survey of the semantic gap in visual image retrieval', in Proceedings of CIVR
2003, volume 2728 of *LNCS*, pp. 291–299. Springer, (2003).

[9] Johannes Fürnkranz and Eyke Hüllermeier, 'Preference learning', *Künstliche Intelligenz*, **2005**(1), 60–61, (2005).

[10] Ralf Herbrich, Thore Graepel, and Klaus Obermayer, 'Large margin rank boundaries for ordinal regression', in *Advances in Large Margin* Classifiers, 115–132, MIT Press, (2000).

[11] Jonathan L. Herlocker, Joseph A. Konstan, Loren G. Terveen, and John T. Riedl, 'Evaluating collaborative filtering recommender systems', *ACM Transactions on Information Systems*, 22(1), 5–53, (2004).

[12] Ihab F. Ilyas, George Beskales, and Mohamed A. Soliman, 'A survey of top-k query processing techniques in relational database systems',
ACM Computing Surveys, 40(4), (2008).

[13] Yehuda Koren, 'Factorization meets the neighborhood: A multifaceted collaborative filtering model', in *Proceedings of KDD 2008*, pp. 426–
434. ACM Press, (2008).

[14] Yehuda Koren, 'Collaborative filtering with temporal dynamics', *Communications of the ACM*, 53(4), 89–97, (2010). [15] Yehuda Koren, 'Factor in the neighbors: Scalable and accurate collaborative filtering', *ACM Transactions on Knowledge Discovery from Data*,
4(1), (2010).

[16] Yehuda Koren, Robert Bell, and Chris Volinsky, 'Matrix factorization techniques for recommender systems', *IEEE Computer*, 42(8), 30–37,
(2009).

[17] Don Monroe, 'Just for you', *Communications of the ACM*, 52(8), 15–
17, (2009).

[18] Gregory Piatetsky-Shapiro, 'Interview with Simon Funk', ACM
SIGKDD Explorations Newsletter, 9(1), 38–40, (2007).

[19] Tapani Raiko, Alexander Ilin, and Juha Karhunen, 'Principal component analysis for large scale problems with lots of missing values',
in *Proceedings of ECML 2007*, volume 4701 of *LNAI*, pp. 691–698. Springer, (2007).

[20] Badrul Sarwar, George Karypis, Joseph Konstan, and John Reidl, 'Itembased collaborative filtering recommendation algorithms', in *Proceedings of WWW 2001*, pp. 285–295. ACM Press, (2001).

[21] J. Ben Schafer, Dan Frankowski, Jon Herlocker, and Shilad Sen, 'Collaborative filtering recommender systems', in The Adaptive Web: Meth-