i.e., *flex* k i ↔ *stub*i). Note that if i weakens, say, *flex* 0 i to the new CAF *flex* 1 i
, then i may be no more able to satisfy *flex* 0 i
.

The rule (C) states that i can just change angle. Suppose that *flex* k i is the last proposal of an agent i during a MN. There are two ways for i to make a new proposal flex k+1 i. In the first case, expressed by the weakening rule (W), i proposes *flex* k+1 iif flex k+1 iis entailed by *flex* k i
(i.e., flex k i → *flex* k+1 i) and flex k i is not the most general formula the agent can negotiate (corresponding to her stubbornness viewpoint, i.e.,
flex k i ↔ *stub*i). In the second case, expressed by the rule (C), i just changes theory.

Although we do not consider MN strategies in detail here, in general, an agent chooses whether to perform a weakening or a changing theory action by applying the corresponding rule, but there are situations in which one action is better than the other. For instance, when an agent checks the compatibility situation it seems better to weaken the theory rather than changing it so to try to entail the opponent's viewpoint, while in essence disagreement situations it seems better to change the theory rather than weakening it so to try to meet the opponent's viewpoint.

If agent i is in stubbornness does she continue the negotiation or does she have to exit it? We assume that the agent exits the MN only if all the agents in the negotiation are stubborn. But an agent does not know the opponent's stubbornness viewpoint, so the exit condition is recognized only by the system. However, the stubborn agent always makes the same proposal during the MN, as expressed by the rule (S). If flex k i ↔ *stub*i then *flex* k1 i = *flex* k1+1 ifor all k1 > k.

Let us now go deeply inside the negotiation process constraints. If an agent i makes a weakening of *flex* 0 i and has *flex* 1 i as the CAF, then i is no more able to satisfy *flex* 0 i
.

As we show below, the process of negotiation, means relaxing of individual hierarchies.

In particular, based upon the reasoning above, flex k i is the k th angle of agent i.

We introduce a set of Σi-structures as agents change angles during the negotiation process and these viewpoints have to be satisfied in different structures. We thus define the semantical structure of a signature, which is built by a domain set and an interpretation function mapping predicate symbols into tuples of elements of the domain.

We use a parameter k to denote the k th structure of the k th angle.

Definition 3 Given a signature Σi = hPi, αii, a Σi*-structure* Ai is a pair hDi
, Ii i where the *domain* Di is a finite non-empty set and the *interpretation function* Ii is such that Ii
(P) ⊆ Dn i for all P ∈ Pifor which α(P) = n.

We define the set of Σi-structures A
k i as Si = {Ak i | Ak i = hDk i
, I
k i i} where D
k i ⊆ Di is the domain set with respect to agent i and, for all pairs (I
k i
, I
k+1 i), if the (k + 1)th rule that agent i applied is:
- (W), then I
k i
(P) ⊆ Ik+1 i(P) for all P ∈ Pi;
- (C), then I
k i
(P) 6= I
k+1 i(P), I
k i
(P) * I
k+1 i(P) and I
k+1 i(P) * I
k i
(P) for all P ∈ Pi;
- (S), then I
k i
(P) = I
k+1 i(P), for all P ∈ Pi.

If ϕ and ψ are Σi-formulas then:
- A
k i |= P(t1*, . . . , t*n) iff (Ii(t1), . . . , Ii(tn)) ∈ Ii(P), where P ∈ Pi and t1*, . . . , t*n are terms;
- A
k i |= ¬ϕ iff A
k i 6|= ϕ;
- A
k i |= ϕ ∧ ψ iff A
k i |= ϕ and A
k i |= ψ;
- A
k i |= ϕ ∨ ψ iff A
k i |= ϕ or A
k i |= ψ;
- A
k i |= ϕ → ψ iff A
k i |= ψ or A
k i |= ¬ϕ.