argument schemes technically have the form of an inference rule: an argument scheme has a set of premises and a conclusion.

The argumentation schemes approach is based upon the Toulmin model of the argumentation (Toulmin, 2003).

The process of resolving conflicts between agents by argumentation involves not only a negotiation dialogue, but also a *persuasion* one (Walton and Krabbe, 1995).

The participants in a negotiation by argumentation propose arguments to the opponents and make counterproposals in two way: by rebutting and or by undercutting the proposals of the opponents. Rebuttal of a rule claiming c, is made by a rule in which the claim is the negation of c. A rule r undercuts a rule r 0if the claim of r is the negation of some of the premises of r 0.

When no undercut and rebuttal rules are available, an agent can accept the argument posted by someone else in the system in two ways (Dung et al, 2007):
- *skeptical*: the argument is acceptable until somebody else claims the contrary;
- *credulous*: the argument is wholeheartedly accepted.

In (Dung, 1995) the author explores the mechanisms humans use in argumentation to state the correctness, the appropriateness and the acceptability of arguments.

To persuade the opponents about the validity of the argument she proposes, the proponent has to *justify* it (Pollock, 1994, 2001; Walton, 2005; Rubinelli, September 2006; Katie Atkinson, 2004; Thakur et al, 2007) or to have its proof. Recent investigations have dealt with the problem about who has the burden of proving a claim and which argument produces a burden of proof (Farley and Freeman, 1995; Walton, 2003; Prakken et al, 2005; Oren et al, 2007; Gordon et al, 2007). In (Iv´an et al, 2000)
a complete survey of the logical models of arguments is presented.

Argumentation Theory is largely used in legal reasoning to model the interactions according to the legal debate rules (Daskalopulu and Sergot, 1997; Gordon and Walton, 2009; Bench-Capon, 1997; Kowalski and Toni, 1996). In particular, in (Bench-Capon et al, 2005), the authors formalise an argumentation framework in order to model the definitions of *objectively* and *subjectively acceptable*, and *indefensible* argument. The definition of the above degrees of acceptance of an argument is based upon a value given to the arguments and a form of preference between them that the agents have.

In (Maudet et al, 2006), the authors present a brief survey of argumentation in multi-agent systems. It is not only brief, but rather idiosyncratic, and focuses on the areas of research of belief revision, agent communication and reasoning.

The second way to model MN is as a set of operations on the beliefs' sets of the agents involved. The scope is to construct a commonly accepted knowledge as the process of merging information becoming from different sources. The problem of how the merging has to be done was approached in two steps:
- how the different sources have inconsistent beliefs and how they are mutually reliable;
- how and when beliefs causing conflicts have to be merged into the knowledge base.

The first point was studied by the *information fusion* researchers and the second by the *belief revision* ones.

In (Gr´egoire and Konieczny, 2006) the author makes a survey of the contributions from the artificial intelligence research literature about logic-based information fusion.

The assumption made by the early approaches were: