In the Bargaining Game, players have a *negotiation power* that represents how often an agent cedes during the negotiation and how much she resists about her current angle.

The negotiation power of an agent is captured by a set of partially ordered angles of her viewpoint. The partial order among the angles allows an agent to choose the next proposal to perform, and to evaluate the acceptability of the received offers. Moreover, the set of partially ordered angles has a minimum that identifies the last offer an agent proposes in a negotiation. We say that each agent has
- one single *stubborn* and
- many *flexible* angles that are respectively the limit proposal (i.e., the last offer) and the acceptable ones, where each flexible angle is consistent with the stubborn knowledge.

The Meaning Negotiation process ends in a positive way (agreement) when both agents agree about a common definition of the meaning of the set of terms, i.e. they propose the same thing, or in a negative way (disagreement) when they are not in agreement and they have no more proposal to perform.

## 1.2 Multiple Parties' Meaning Negotiation

When the number of agents is more than two, the negotiation is multiparty and each proposal has one sender and many receivers. A proposal may be accepted or rejected by all the agents or by only some of them, and the receivers may answer in different ways. The negotiation process for multiparty scenarios is computationally harder than the bilateral one and it needs the organization of the order in which agents make assertions
(proposals, acceptance or rejection of offers) during the process. The modeling of the Meaning Negotiation in this case depends also on the role of the involved agents. Having n + 1 agents in the negotiation, the possible role distinctions are:
- 1-n: one seller and many buyers; - n-1: many sellers and one buyer;
- n1-n2: many sellers and many buyers.

In the first case, the agents behave like in an auction. Before entering the auction, the seller establishes a maximal price for the item. The seller begins the game by making the initial request that is the *reservation price*. The auction develops by *beats*. A beat consists of:
1. the seller makes a request; 2. each buyer proposes a counteroffer or accepts the seller's proposal.

No more beat begins if the maximal price is reached or if the buying agents do not make new proposals. In an auction scenario, a proposal is also called a bid. The end of the auction is established by the seller, i.e. by the auctioneer. In general, in an auction there is only one winner, i.e. only one agent buys the item in the auction.

The second case, n-1, is similar to the first one. The sellers have to convince the buyer to accept the price they propose and when the buyer is not convinced she has to respond with another offer. In the Meaning Negotiation perspective, a buyer is not different from a seller because they have the same feasible action: accept an offer, reject an offer or make a proposal. Even if the agents generally have different strategies depending on their role, i.e. typically a buyer enhances instead the seller fall the last 5