offer, the purpose of the seller and of the buyer is the same: to meet the opponent's request. Therefore, buyers and sellers make new proposals in the same way, that is by ceding their last one.

The third case, n1-n2, is called *fish market*. For a reference on the different ways to perform negotiation, see Lomuscio et al (2003). It is not possible to make a modeling of the MN of this multiple-agent system structure because there is no agent monitoring the process and no behavioral guidelines for the players. In the first two cases, the auctioneers, the seller in the first and the buyer in the second, are the agents who control the Meaning Negotiation process and check whether an agreement is reached between the involved agents. As in the auction game, in the fish market each agent makes a proposal or accepts/rejects the opponents' one but there is no coordination among the agents. It may be the case that two or more agents make proposals simultaneously so each agent is a buyer, i.e. she makes an offer, and a seller, i.e. she evaluates the received offers, at the same time. The result is that a common proposal is difficult to find. In the worst case, where there are n agents involved in negotiation in total, this means there can be up to n(n − 1)/2 negotiation threads. Clearly, from an analysis point of view, this makes such negotiation hard to handle.

In this paper, as in the main approach in the current Artificial Intelligence literature, we model the multiparty MN by reserving an agent, typically the first bidding one, to be the referee of the process and the game used to represent it is the auction. In Game Theory, there are several auction types (Benameur et al, 2002): English, Dutch, Vickrey, First-price sealed-bid etc. The types of auction differ on the behavior of the agents involved and on the number of the proposals the agents make. In this paper we use the English Auction because the agents behave as in the Bargaining Game. The English Auction Game begins by the proposal of the auctioneer that is called *reservation price* and it is the minimum price the agents have to pay to win the auction. In the next step of the English Auction, each player makes her offer by incrementing the last bidden one, i.e. the auctioneer's proposal. There is not a fixed number of turns for agents' bidding, instead the game continues until no more bids are performed. The game ends with a winner that is the agent who bids the highest offer.

In a MN perspective, the English Auction game is slightly different in the outcome.

The goal of the negotiation is agents in sharing a viewpoint. Therefore the positive ending condition of the game is that all the agents make the same bid and the bidden proposal is the representation of their viewpoints.

There are MN contexts in which it is sufficient to have a "major" part of agreeing agents to consider positive the negotiation. In general "major part" means that a number of agents, typically more then 50% , but it may mean that a part of the most trustworthy agents are in agreement. In the former case, the minimum number of agreeing agents is a parameter of the game: suppose α is the chosen number for "major part", the MN continues until at least α agents agree about a common angle.

The minimum number of agreeing agents is called *degree of sharing*. A MN process for more than two agents, say n agents, has two positive ending conditions and two types of positive outcomes, if a positive outcome exists:
6