# Information-Theoretic Measures Associated With Rough Set Approximations

Ping Zhua,b, Qiaoyan Wen b aSchool of Science, Beijing University of Posts and Telecommunications, Beijing 100876, China b*State Key Laboratory of Networking and Switching, Beijing University of Posts and Telecommunications, Beijing 100876, China*

## Abstract

Although some information-theoretic measures of uncertainty or granularity have been proposed in rough set theory, these measures are only dependent on the underlying partition and the cardinality of the universe, independent of the lower and upper approximations. It seems somewhat unreasonable since the basic idea of rough set theory aims at describing vague concepts by the lower and upper approximations. In this paper, we thus define new informationtheoretic entropy and co-entropy functions associated to the partition and the approximations to measure the uncertainty and granularity of an approximation space. After introducing the novel notions of entropy and co-entropy, we then examine their properties. In particular, we discuss the relationship of co-entropies between different universes.

The theoretical development is accompanied by illustrative numerical examples.

Keywords: Rough set, entropy, co-entropy, uncertainty, granularity

## 1. Introduction

To handle inexact, uncertain or vague knowledge in some information systems, Pawlak developed rough set theory in the early 1980s [14, 15]. Since then we have witnessed a systematic, world-wide growth of interest in rough set theory and its applications in a number of fields, such as granular computing, data mining, decision analysis, pattern recognition, and approximate reasoning [12, 17, 18, 30, 34, 35].

The starting point of rough set theory in [14, 15] is the idea that elements of a universe having the same description are indiscernible with respect to the available information. The indiscernibility was described by an equivalence relation in the way that two elements are related by the relation if and only if they are indiscernible from each other.

As is well known, any equivalence relation defined on a universeU determines a partition ofU into a collection of equivalence classes (blocks): each class contains all and only the elements that are mutually equivalent among them.

Any partitionπ ofU represents a piece of knowledge about the elements ofU forming a classification and so any equivalence class induced byπ is interpreted as a granule of knowledge contained in (or supported by)π.

According to Pawlak's terminology expressed in [16], any subsetX of the universeU is called a concept in U. If the conceptX is a union of equivalence classes fromπ, thenX is precise inπ, otherwiseX is vague. The basic idea of rough set theory consists in replacing vague concepts with a pair of precise concepts, its lower and upper approximations [16], and thus, a basic problem in this framework is to reason about the accessible granules of knowledge. To this end, various knowledge granulations (also, information granulations or granulation measures), as an average measure of knowledge granules, have been proposed and addressed in [1, 3, 8, 11, 13, 21, 23, 24, 25, 26, 28, 32]. Among them, there are several information-theoretic measures of uncertainty or granularity for rough sets [1, 3, 8, 10, 11, 13, 21, 23, 25], which are based upon the important notion of entropy introduced by Shannon [22];
for more details, we refer the reader to the excellent survey papers [2, 27].

It is worth noting that the information-theoretic measures mentioned above are only dependent on the sizes of equivalence classes (essentially, the underlying partition) and the cardinality of the universe, independent of the lower Preprint submitted to Elsevier October 31, 2018 arXiv:1102.0079v1 [cs.AI] 1 Feb 2011