Recall that a *partition* of U is a collection of nonempty subsets of U such that every element x of U is in exactly one of these subsets; such subsets making up the partition are called *blocks*. We write Π(U) for the set of all partitions of U and P(U) for the power set of U. It is well-known that the notions of partition and equivalence relation are essentially equivalent, that is, for any equivalence relation R on U, the set U/R is a partition of U, and conversely, from any partition π of U, one can define an equivalence relation Rπ on U such that U/Rπ = π in the obvious way. Thus, we sometimes say that the ordered pair hU, πi is an approximation space and write appπ X and appπX for appRπ X and appRπ X, respectively. More generally, we will use equivalence relation and partition indiscriminately.

If a universe U has more than one element, it is always possible to introduce at least two canonical partitions: One is the trivial partition, denoted by ˇπ, consisting of a unique block, and the other is the discrete partition, denoted by ˆπ, consisting of all singletons from U. Formally, πˇ = {U} and ˆπ = {{x} | x ∈ U}.

We now define a partial order "" on Π(U): For any π, σ ∈ Π(U), σ  π if and only if for any C ∈ σ, there exists D ∈ π such that C ⊆ D. For instance, ˆπ  π  πˇ for any π ∈ Π(U). We say that σ is *finer* than π and that π is *coarser* than σ if σ  π. When σ ≺ π, that is, σ  π and σ , π, we say that σ is *strictly finer* than π and that π is *strictly* coarser than σ. Informally, this means that σ is a further fragmentation of π.

2.2. Information-theoretic measures In this subsection, we review two information-theoretic measures associated with rough sets in the literature.

These measures are concerned with the uncertainty or granularity of knowledge provided by a partition.

In [6, 13, 23, 26], Shannon entropy [22] has been used as a measure of information for rough set theory as follows. For subsequent need, we fix a notational convention: Throughout the paper, all logarithms are to base 2 unless otherwise specified.

Definition 2.1 ([6, 13, 23, 26]). Let hU, πi be an approximation space, where the partition π *consists of blocks U*i, 1 ≤ i ≤ k, each having cardinality ni*. The* information entropy H(π) of partition π *is defined by*

$$H(\pi)=-\sum_{i=1}^{k}{\frac{n_{i}}{n}}\log{\frac{n_{i}}{n}},\;w h e r e\;n=\sum_{i=1}^{k}n_{i}.$$
$$(1)$$

$$(2)$$
ni. (1)
When π = πˇ, the entropy function H achieves the minimum value 0, and when π = πˆ, it achieves the maximum value log n. Moreover, it has been shown in [23] that for any two partitions π and σ of U, if σ ≺ π, then H(σ) > H(π).

The equation (1) can be rewritten as follows:

$$H(\pi)=\log n-\sum_{i=1}^{k}{\frac{n_{i}}{n}}\log n_{i}.$$

log ni. (2)
Recall that the Hartley measure [7] of uncertainty for a finite set X is H(X) = log |X|, where "|X|" denotes the cardinality of the set X. It measures the amount of uncertainty associated with a finite set of possible alternatives, the nonspecificity inherent in the set.

The first term log n (i.e., log |U|) in Eq. (2) is exactly the Hartley measure of U, which is a constant independent of any partition. The second term of the equation is basically an expectation of granularity with respect to all blocks in a partition. This quantity has been used by Yao to measure the granularity of a partition in [26] and has been defined by Liang and Shi as the rough entropy of knowledge in an approximation space in [11]. This quantity has also been referred to as co-entropy by some scholars (see, for example, [2, 3]).

Definition 2.2 ([2, 3, 11, 26]). Let hU, πi be an approximation space, where the partition π *consists of blocks U*i, 1 ≤ i ≤ k, each having cardinality ni*. The* co-entropy G(π) of partition π is defined by

$$G(\pi)=\sum_{i=1}^{k}{\frac{n_{i}}{n}}\log n_{i},\;w h e r e\;n=\sum_{i=1}^{k}n_{i}.$$
$$(3)$$

ni. (3)
$\mathbf{a}$