modelo más plausible y por lo general implica una explicación de las observaciones. Sin embargo, estas nociones se usan frecuentemente como sinónimos. De hecho, el papel seminal de Solomonoff [Solomonoff 1964] se refiere a "la teoría de la inferencia inductiva" cuando realmente se refiere a "la teoría de la predicción". Además, también hay importantes diferencias entre la compresión en una parte y la compresión en dos partes (inducción MML). En el primer caso, el modelo no distingue entre patrones y excepciones mientras que la segunda explícitamente separa las regularidades (patrón principal) de las excepciones. Véase [Wallace 2005] (sec. 10.1) y [Dowe 2008] (parte de sec. 0.3.1 refiriéndose a Solomonoff) para más detalles de esto. 

Uno de los principales problemas de la Teoría de Información Algorítmica es que la Complejidad Kolmogorov es incomputable. Una solución popular al problema de la computabilidad de K() **para cadenas finitas es utilizar una versión de tiempo limitado o** 
ponderada de la complejidad de Kolmogorov (y por lo tanto de la distribución universal de la que se deriva). Una elección popular es la complejidad Kt de Levin [Levin 1973] [Li & 
Vitanyi 2008]: 
DEFINICIÓN 7. COMPLEJIDAD KT DE LEVIN

$Kt_{U}(x)=\min\limits_{p}\left\{l(p)+\text{logitme}(U,p,x)\right\}$
Donde *l(p)* denota la longitud en bits de p, *U(p)* **denota el resultado de ejecutar** p **en** U
y *time(U,p,x)* denota el tiempo que U utiliza ejecutando p **para producir** x. 

Finalmente, a pesar de la incomputabilidad de K y la complejidad computacional de sus aproximaciones, han habido algunos esfuerzos en utilizar la Teoría de Información Algorítmica para diseñar una búsqueda óptima o estrategias de aprendizaje. La búsqueda de Levin (o universal) [Levin 1973] **es un algoritmo de búsqueda iterativo para resolver** problemas de inversión basados en Kt, el cual ha inspirado a otras estrategias de agente general como AIXI de Hutter, un agente que es capaz de adaptarse óptimamente en algunos entornos [Hutter 2007], para los que existe una aproximación de trabajo [Veness et al 2009]. 

En [Hernandez-Orallo & Dowe 2010] se introduce una variante de la complejidad anterior que permite asegurar que las interacciones terminan en un tiempo corto, haciendo por tanto factible la medición usando la distribución que se deriva de ella. 

La aproximación considera un tiempo máximo para cada salida. Primero definimos 
∆*ctime(U, p, i)* como el tiempo necesario para imprimir el par <ri,oi> tras la acción ai−1**, es** 
decir el tiempo de ciclo de respuesta. A partir de aquí podemos establecer el límite superior para el tiempo de cómputo máximo que el entorno puede consumir para generar la recompensa y la observación después de la acción del agente. 

DEFINICIÓN 8. COMPLEJIDAD KT PONDERANDO LOS PASOS DE LA INTERACCIÓN

$Kt^{\max}{}_{U}(x,n)=\min_{p}\min_{p}\left\{l(p)+\log\left(\max_{i\leq n}(\Delta\mathit{ctime}(U,p,i))\right)\right\}$

