# New Worst-Case Upper Bound For #Xsat

Junping Zhou, Minghao Yin Department of Computer, Northeast Normal University, Changchun, China, 130117 ymh@nenu.edu.cn

## Abstract

An algorithm running in O(1.1995n) is presented for counting models for exact satisfiability formulae(\#XSAT). This is faster than the previously best algorithm which runs in O(1.2190n). In order to improve the efficiency of the algorithm, a new principle, i.e. the common literals principle, is addressed to simplify formulae. This allows us to eliminate more common literals. In addition, we firstly inject the resolution principles into solving \#XSAT problem, and therefore this further improves the efficiency of the algorithm.

## Introduction

Tremendous efforts have been made on analyzing algorithms for difficult problems, such as propositional satisfiability (SAT) 
or model counting (\#SAT). If P ≠ NP, these problems are all super-polynomial. When constructing the super-polynomial algorithms, improvements in the exponential time bounds are crucial in determining the size of these problems that can be solved, for even a slight improvement from O(c k) to *O((c*-)
k) may significantly increase the size of these problems being tractable. Take the 3-SAT problem for example. The currently fastest deterministic algorithm for solving 3-SAT (Kutzkov et al. 2010) ran in O(1.439n), which is a meaningful advance over O(2 n). And the 3-SAT instances with 65 variables can be solved by the algorithm in approximately 1010 steps, instead of 1019 (which may not be tractable). Therefore, it is significant to improve the upper bounds on the worst-case running time for problems with high computational complexity.

\#XSAT is one of hard problems whose computational complexity is further up the polynomial hierarchy. Valiant (1979) 
has proved that \#XSAT is \#P-complete. This is a problem of computing the number of models for a given formula in Conjunction Normal Form (CNF), i.e., the number of distinct complete truth assignments to variables such that exactly one literal in each clause evaluates to *true*. In fact, the problem is a vital variant of the well-known \#SAT problem, which has a wide range of applications, such as various probabilistic inference problems can be translated into \#SAT problem (cf. Park 2002; Sang et al. 2005).