Recently, most of the efforts in algorithm construction have been dedicated to algorithms for \#XSAT problem. For example, based on an algorithm for counting all maximum weight independent sets in a simple graph, Dahllof and Jonsson
(2002) presented an upper time bound for \#XSAT (O(1.7548n), where n is the number of the variables). Further improved algorithm in (Porschen 2005) proposed a new upper time bound for the \#XSAT (O(1.3248n)). Instead of only outputting the number of models, Porschen in 2006 presented an algorithm solving \#XSAT for enumerating all exact models of the input formula. By addressing a simple reduction, Dahllof et al. (2004) presented a \#XSAT algorithm which ran in O(1.2190n),
which is the best upper bound so far.

The aim of this paper is to exploit new upper bounds for \#XSAT. We provide an algorithm for solving \#XSAT. This algorithm employs a new principle, i.e. the common variables principle, to simplify formulae. This allows us to eliminate more common variables, and therefore improves the efficiency of the algorithm. In addition, we firstly inject the resolution principles into solving \#XSAT problem, which further improves the efficiency of the algorithm. By analyzing the algorithm, we present a deep analysis and obtain the worst-case upper bound O(1.1995n) for \#XSAT.

## Problem Definitions

We describe some definitions used in this paper. Let V be a set of propositional variables. Each variable can take the values true or *false*. A literal is either a variable x or its negationx. Also, each literal can take the values true or *false*. If a literal is l, the negation of the literal isl. The logic disjunction of a finite number of literals forms a clause. A clause containing exactly k literals is also called k-*clause*. The length of a clause is the number of literals in it, denoted byC. A clause C is a unit clause if the length of the clause is 1. And if there is a clause x1 x2  ... xi C such that C is a disjunction of one or more literals, we call C is a sub-clause. A formula F in Conjunction Normal Form (CNF) is a logic conjunction of a set of clauses. A variable occurring once in F is referred to as singleton. The degree of a variable x, represented by(x), is the number of times it occurs in F. The degree of a formula F, denoted by(F), is the maximum degree of variables in F. A 
literal l is an (i
+, j
+)-literal if F contains at least i occurrences of l and at least j occurrences ofl. A literal l is an (i, j)-literal if F contains exactly i occurrences of l and exactly j occurrences ofl. And a literal l is monotone if its complementary literal does not appear in F. A truth assignment for F is a map that assigns each variable a value. When a truth assignment makes the F *true*, we say that the truth assignment satisfies F. The *exact satisfiability problem* (XSAT) is to determine if a CNF- formula has a truth assignment satisfying exactly one literal in each clause. The satisfying assignment of the XSAT, called as a model, is a truth assignment such exactly one literal in each clause is *true*. The counting exact satisfiablity problem 