(\#XSAT) is to compute the number of models for a formula. We define M(F) as the number of models of the formula *F, m* as the number of clauses in F, n as the number of variables F contains, Var(C) as the variables in C, lit(C) as the set of literals in the clause C, and lit (C')-lit (C) as the set of literals that appear in the clause C' but not in the clause C. We also use F(µ/η) to denote the substitution of µby η in the formula F, where µis either a literal or a clause and η is either a literal or *false*. To avoid a tedious enumeration of trivialities, if more than one literal is substituted by *false*, µis usually expressed as a set of literals.

A formula F in CNF can be expressed as an undirected graph called constraint graph. In the constraint graph G, the vertexes are the variables of F and the edges between two vertexes if the corresponding variables appear together in some clause of F. A component of such a graph is a maximal sub-graph such that for every pair of vertices in the sub-graph, there is a path between the pair of vertices. Let F1, F2, …, Fk be the sub-formulae of F corresponding to the components. Then, M(F)=M(F1)M(F2) …M(Fk) (1)
Given a formula F, the basic strategy of Davis-Putnam-Logemann-Loveland (DPLL) is to arbitrarily choose one or more variables that appear in F. That means that we branch on one or more variables in the formula F, i.e., we assign values to the variable(s) such that the problem for F is reduced to the problem for two or more formulae.

## Estimating The Running Time

In this section, we explain how to compute an upper bound on the running time of a DPLL-style algorithm. At first, we present a notion called branching tree. The branching tree (Hirsch 2000) is a hierarchical tree structure with a set of nodes, each of which is labeled with a formula. Suppose there is a node labeled with a formula F, then its sons labeled with F1, F2, … , Fk are obtained by branching on one or more variables in the formula F, i.e., assigning values to the variable(s) such that the formula F is reduced to two or more sub-formulae F1, F2, … , Fk with fewer variables. Indeed, the construction of a branching tree can be viewed as an execution of a DPLL-style algorithm. Therefore, we use the branching tree to estimate the running time of our algorithm.

 Suppose there is a branching tree whose nodes are labeled with formulae. To each node we attach a branching vector. Let us consider a node labeled with F and its sons labeled with F1, F2, …, Fk. The branching vector of the node labeled with F is a k-tuple (r1, r2,…, rk), where ri=f (F)-f (Fi) and ri >0 (1≤ i ≤ k and f (F) is the number of variables of F). From the definition of the branching vector of the node, it is easy to see that the branching tree requires that each sub-formula has smaller 