
## 3.3 Sets Of Se-Interpretations Representable By A Rule

Naturally, not all sets of SE-interpretations correspond to a single rule, otherwise any program could be reduced to a single rule. The conditions under which a set of SE-interpretations is rule-representable are worth examining.

A set of SE-models S of a program is always *well-defined*, i.e. whenever S contains h**I, J**i, it also contains h**J, J**i. Moreover, for every well-defined set of SE-interpretations S there exists a program P such that S = modSE (P) [10].

We offer two approaches to find a similar condition for the class of rulerepresentable sets of SE-interpretations. The first is based on induced rules defined in the previous Subsection, while the second is formulated using lattice theory and is a consequence of Lemma 8.

The first characterisation follows from two properties of the rule(·) transformation.

First, it can be applied to any set of SE-interpretations, even those that are not rulerepresentable. Second, if rule(S) = r, then it holds that modSE (r) is a subset of S.

Lemma 16. The set of all SE-models of a canonical rule r is the least among all sets of SE-interpretations S *such that* rule(S) = r.

Proof. See Appendix A, page 22. ⊓⊔ Thus, to verify that S is rule-representable, it suffices to check that all interpretations from S are models of rule(S).

The second characterisation follows from Lemma 8 which tells us that if S is rulerepresentable, then its complement consists of SE-interpretations h**I, J**i following a certain pattern. Their second component J always contains a fixed set of atoms and is itself contained in another fixed set of atoms. Their first component I satisfies a similar property, but only if a certain further condition is satisfied by J. More formally, for the sets

$$I^{\perp}=B(r)^{+},\quad I^{\top}={\mathcal L}\setminus H(r)^{+},\quad J^{\perp}=H(r)^{-}\cup B(r)^{+},\quad J^{\top}={\mathcal L}\setminus B(r)^{-},$$

it holds that all SE-interpretations from the complement of S are of the form h**I, J**i where J
⊥ ⊆ J ⊆ J
⊤ and either J ⊆ I
⊤ or I
⊥ ⊆ I ⊆ I
⊤. It turns out that this also holds vice versa: if the complement of S satisfies the above property, then S is rule-representable. Furthermore, to accentuate the particular structure that arises, we can substitute the condition J
⊥ ⊆ J ⊆ J
⊤ with saying that J belongs to a convex sublattice of I.

1 A similar substitution can be performed for I, yielding:
Theorem 17. Let S be a set of SE-interpretations. Then the following conditions are equivalent:
1. The set of SE-interpretations S is rule-representable.

2. All SE-interpretations from S are SE*-models of* rule(S).