equivalent, but not SR-equivalent is P = { **p., q.** } and Q = { **p., q** ← p. }, which in many cases need to be distinguished from one another. We believe that this notion of program equivalence is much more suitable for cases when the dependency information contained in a program is of importance.

In certain cases, however, SR-equivalence may be too strong. For instance, it may be desirable to treat programs such as P1 = { p ← q. } and P2 = { p ← q., p ← **q, r.** } in the same way because the extra rule in P2 is just a weakened version of the rule in P1.

For instance, the notion of *update equivalence* introduced in [23], which is based on a particular approach to logic program updates, considers programs P1 and P2 as equivalent because the extra rule in P2 cannot influence the result of any subsequent updates.

Since these programs are not SR-equivalent, we also introduce the following notion of program equivalence, which in terms of strength falls between strong equivalence and SR-equivalence.

Definition 20 (Strong Minimal Rule Equivalence). Programs P1,P2 are SMR-equivalent*, denoted by* P1 ≡SMR P2*, if* min { modSE (r) | r ∈ P1 ∪ { ε } } **= min** { modSE (r) | r ∈ P2 ∪ { ε } } ,
where min S *denotes the set of subset-minimal elements of* S.

In order for programs to be SMR-equivalent, they need not contain exactly the same rules (modulo strong equivalence), it suffices if rules with subset-minimal sets of SE-models are the same (again, modulo strong equivalence). Certain programs, such as P1 and P2 above, are not SR-equivalent but they are still SMR-equivalent.

Related to this is the very strong notion of equivalence which was introduced in [2]:
Definition 21 (Strong Update Equivalence, c.f. Definition 4.1 in [2]). *Two programs* P1, P1 are SU-equivalent, denoted by P1 ≡SU P2, if for any programs Q, R it holds that the program ((P1\Q)∪R) *has the same answer sets as the program* ((P2\Q)∪R).

Two programs are strongly update equivalent only under very strict conditions –
it is shown in [2] that two programs are SU-equivalent if and only if their symmetric difference contains only SE-tautological rules. This means that programs such as Q1 =
{ ∼p. }, Q2 = { ← p. } and Q3 = { ∼p ← p. } are considered to be mutually nonequivalent, even though the rules they contain are mutually SE-equivalent. This may be seen as too sensitive to rule syntax.

The following result formally establishes the relations between the discussed notions of program equivalence:
Theorem 22. SU-equivalence is stronger than SR*-equivalence, which itself is* stronger than SMR*-equivalence, which in turn is stronger than strong equivalence.*
That is,
≡SU ≻ ≡SR ≻ ≡SMR ≻ ≡S .

Proof. See Appendix A, page 24. ⊓⊔