assigned to the program, they carry essential information about mutual interdependencies between literals that cannot be captured by answer sets. Examples that enjoy these characteristics include the numerous approaches that deal with dynamics of logic programs, where inconsistencies between older and newer knowledge need to be resolved by "sacrificing" parts of an older program (such as in [3–11]). These approaches look at subsets of logic programs in search of plausible conflict resolutions. Some of them go even further and consider particular literals in heads and bodies of rules in order to identify conflicts and find ways to solve them. This often leads to definitions of new notions which are too syntax-dependent. At the same time, however, semantic properties of the very same notions need to be analysed, and their syntactic basis then frequently turns into a serious impediment.

Arguably, a *more* syntax-independent method for this kind of operations would be desirable. Not only would it be theoretically more appealing, but it would also allow for a better understanding of its properties with respect to the underlying semantics. Moreover, such a more semantic approach could facilitate the establishment of bridges with the area of Belief Change (see [12] for an introduction), and benefit from the many years of research where semantic change operations on monotonic logics have been studied, desirable properties for such operations have been identified, and constructive definitions of operators satisfying these properties have been introduced.

However, as has repeatedly been argued in the literature [4, 13], fully semantic methods do not seem to be appropriate for the task at hand. Though their definition and analysis is technically possible and leads to very elegant and seemingly desirable properties, there are a number of simple examples for which these methods fail to provide results that would be in line with basic intuitions [4]. Also, as shown in [13],
these individual problems follow a certain pattern: intuitively, any purely semantic approach to logic program updates satisfying a few very straightforward and desirable properties cannot comply with the property of *support* [14, 15], which lies at the very heart of semantics for Logic Programs. This can be demonstrated on simple programs P = { **p., q.** } and Q = { **p., q** ← p. } which are *strongly equivalent*, thus indistinguishable from the semantic perspective, but while P does not contain any dependencies, Q
introduces a dependence of atom q upon atom p. This has far-reaching consequences, at least with respect to important notions from the logic programming point of view, such as that of *support*, which are themselves defined in syntactic rather than semantic terms. For example, if we change our beliefs about p, and come to believe that it is false, we may expect different beliefs regarding q, depending on whether we start form P, in which case q would still be true, or Q, in which case q would no longer be true because it is no longer supported.

We believe that rules indeed contain information that, to the best of our knowledge, cannot be captured by any of the existing semantics for Logic Programs. In many situations, this information is essential for making further decisions down the line. Therefore, any operation on logic programs that is expected to respect syntax-based properties like *support* cannot operate solely on the semantic level, but rather has to look inside the program and acknowledge rules as the atomic pieces of knowledge. At the same time, however, rules need not be manipulated in their original form. The abstraction provided by Logic Programming semantics such as SE-models can be used to discard