other words, every rule is SE-equivalent to exactly one canonical rule. To this end, we define constructive transformations that directly show the mutual relations between rule syntax and semantics.

The following transformation provides a direct way of constructing a canonical rule that is SE-equivalent to a given rule r.

Definition 6 (Transformation into a Canonical Rule). Given a rule r*, by* can(r) we denote a canonical rule constructed as follows: If any of the *sets* H(r)
+ ∩ B(r)
+,
H(r)
− ∩ B(r)
− and B(r)
+ ∩ B(r)
− *is nonempty, then* can(r) is ε*. Otherwise,* can(r)
is of the form H+; ∼H− ← B+, ∼B−. *where*
- H+ = H(r)
+ \ B(r)
−.

- If H+ is empty, then H− = ∅ and B+ = B(r)
+ ∪ H(r)
−.

- If H+ *is nonempty, then* H− = H(r)
− \ B(r)
+ and B+ = B(r)
+.

- B− = B(r)
−.

Correctness of the transformation follows directly from Lemmas 2 to 4.

Theorem 7. Every rule r is SE*-equivalent to the canonical rule* can(r).

## Proof. See Appendix A, Page 18. ⊓⊔

What remains to be proven is that no two different canonical rules are SE-equivalent. In the next Subsection we show how every canonical rule can be reconstructed from the set of its SE-models. As a consequence, no two different canonical rules can have the same set of SE-models.

## 3.2 Reconstructing Rules

In order to reconstruct a rule r from the set S of its SE-models, we need to understand how exactly each literal in the rule influences its models. The following Lemma provides a useful characterisation of the set of countermodels of a rule in terms of syntax:
Lemma 8 (Different formulation of Theorem 4 in [21]). Let r be a rule. An *SE-interpretation* h**I, J**i is not an SE-model of r *if and only if the following conditions are* satisfied:
1. H(r)
− ∪ B(r)
+ ⊆ J and J **⊆ L \** B(r)
−.

2. Either J **⊆ L \** H(r)
+ *or both* B(r)
+ ⊆ I and I **⊆ L \** H(r)
+.

Proof. See Appendix A, page 18. ⊓⊔
The first condition together with the first disjunct of the second condition hold if and only if J is not a C-model of r. The second disjunct then captures the case when I is not a C-model of r J.

If we take a closer look at these conditions, we find that the presence of a negative body atom in J guarantees that the first condition is falsified, so h**I, J**i is a model of r, regardless of the content of I. Somewhat similar is the situation with positive head atoms - whenever such an atom is present in I, it is also present in J, so the second