
## 6. **Conclusion**

The Web service composition problem is a challenging research issue because of the growth in the number of Web services available, the dynamic environment and changing user needs. We have presented an agent based architecture that, dynamically, composes Semantic Web Services. This architecture allows defining different levels of responsibility: -constructing semantically the user request assured by the request constructor agent according to the global BPs ontology, 
- Attribution a task to composer agent or directly to manager agent assured by the general manager agent according to its global view of the system, - composing and coordinating the composite service execution assured by the composer agent. The proposed composition model is based on the distributed planning with the dialectical synthesis of plans under hypotheses. The originality of our model is that the solution plan succeeding is not totally distributed because of the use of a composer agent who collaborates with various manager agents (which present Web services used in the composition process). 

The idea is that there is always an agent who oversees the progress state of the composition process and who has a global vision allowing to localize the problem in a failure case. We have implemented the *Request Constructor Agent* by using several packages such as: JDOM, OWLAPI, OWL-S_API. The proposed architecture can be implemented within the ebXML functional specification for ebXML BPs composition. Future work will focus mainly on managing the dynamic availability and not availability of the various manager agents. 

## References

[1] A.Ben Hassine, Shigeo Matsubara & Toru Ishida, (2006) "A Constraint-based Approach to Horizontal Web Service Composition", 5th International Semantic Web Conference (ISWC2006), Athens, GA, USA, 
November 5-9, 2006. [2] OWL Services Coalition, (2003)" OWL-S: Semantic markup for web services", OWL-S White Paper http://www.daml.org/services/owl-s/1.0/owl-s.pdf. 

[3] A. Ankolekar., M.Burstein., J.R.Hobbs., O.Lassila., D.L.Martin, D.McDermott, S.A. McIlraith., S.Narayanan, M.Paolucci, T.R.Payne & K.Sycara, (2002) "DAML-S: Web Service Description for the Semantic Web", In Horrocks, I., Hendler, J., eds.: Proceedings of the First International Semantic Web Conference (ISWC2002), Sardinia, Italy. Volume 2342 / 2002 of Lecture Notes in Computer Science., Springer-Verlag Heidelberg (2002),pp 348-363. [4] K.Sycara, M.Paolucci, A. Ankolekar & N. Srinivasan (2003) "Automated discovery, interaction and composition of semantic web services", Journal of Web Semantics 1 (2003), pp 27-46 [5] D.Wu, E.Sirin, B.Parsia, J.Hendler & D.Nau (2003) "Automatic web services composition usingSHOP2", In: Proceedings of ICAPS'03Workshop on Planning for Web Services, Trento, Italy. [6] M.Pasha and H. Farouq Ahmad (2008) "Agents Negotiating with Semantic Web Services", Proceedings of the World Congress on Engineering and Computer Science 2008WCECS 2008, October 22 - 24, 2008, San Francisco, USA. 

[7] Web Services Architectures, W3C Working Draft 14 May 2003: http://www.w3.org/TR/2003/WDws-arch-20030514/
[8] M.Lyell, L.Rosen, L.Casagni-Simkins & D.Norris (July, 2003) "On software agents and web services", In Proc. of the 1st International Workshop on Web Services and Agent Based Engineering, Sydney, Australia. 