
## 2. Related Work

Various composition techniques of Web Services exist in the literature. There are two groups : 
the static techniques i.e., which are defined by means of Business Process (orchestration and choreography); and the dynamic ones, in which the composition of Web services takes into account available services, their features and purpose to be reached. Techniques of dynamic composition can be grouped in two sub-families: techniques using an approach based on workflows (BPs) and those based on techniques on artificial intelligence. In our work, we are interested in the second type of composition in which preferences and constraints of the customers will be considered. 

Several works have proposed different automated planning techniques to address the problem of automated composition (see, e.g., [12, 21, 22, 5]). In this paper, we are interested to this type of research works. These works lean essentially on the classic planning [22, 23, 24], the planning was based on rules [25] and the hierarchical planning [5]. Most of these works advanced the fact that the syntactic description (WSDL) of the services is not sufficient and proposed solutions based on a semantic description (OWL-S). 

The collective planning, in a multi-agents context, is also a promising solution because of the correspondence between the notion of atomic and composite process of OWL-S and that of operator and of method in the planning. The objective is to have agents capable of collaborating to realize a common purpose. In distributed planning, the domain of planning is distributed on all agents. Every agent is capable of realizing certain number of actions: its competences. It is the pooling and the organization of the competences of every agent, with the aim of resolving the given problem that is going to allow bringing to the foreground a solution plan. This type of planning is the one which interests us most, to build the model of composition of the Web services in the architecture on agents' proposed base. The peculiarity of our composition model lives in the fact that the outcome to a solution plan is not totally distributed because we use an agent composer allowing to collaborate with the various manager agents (reserved Web services). The idea is that there is always an agent capable of overseeing the state of progress of the process of composition and of being able to localize the problem in case of failure. 

## 3. Using A Multi-Agent System As A Dynamic Service Composition Infrastructure

A Multi-Agent System (MAS) is a distributed system composed of autonomous entities, called agents. These agents need to interact and cooperate in order to achieve global tasks. One of the main properties of MAS is that it relies on the distribution of cooperation algorithms rather than on centralized processes. We underline two main features of MAS with regard to dynamic service composition. MAS enable complex interactions between entities, using high level semantic languages. This feature seems essential in environments dealing with various, heterogeneous *information* from physical sensors, services or users preferences. Integration of such data is only possible at a higher level where all kind of information (about services, context ...) is expressed semantically. In MAS, autonomous entities with limited capabilities coordinate in order to achieve complex tasks. *Emergent coordination and flexible organization* patterns enable groups of agents to create and reconfigure application dynamically depending on conditions. Such patterns seem well adapted to dynamic composition of elementary functionalities in an open, dynamic environment. 