
## Definition 5.1 (Operator)

An operator can be defined by the quadruplet: o = (name(o), precond(o), add(o), del(o)) - name(o), the operator name, is defined by the following expression n(x1, . . . , xk) where n is Operator's symbol and x1, . . . , xk represent the parameters of the operator. 

- precond(o) represent the preconditionc of the operator o, i.e., the world properties necessary for its execution. - add(o) and del(o) define two sets of properties describing respectively the facts to be added and the facts to be deleted of the world state after the execution of o. 

## Definition 5.2 (Action)

An action is an instance of an operator. If a is an action and *si* is a state such as precond+(a)si and precond−*(a) si=* then a is applicable in si, and the result of this application is the state: 
si+1 = γ(si, a) = (si − effets−(a)) U *effets+*(a) 

## Definition 5.3 (Planning Domain)

In planning, a domain defines all the operators who can apply to the world. A problem has to specify the initial state as well as the purpose to achieve. A domain D of L is a restricted state transition system Σ= (S, A,γ ) such as : 
- S = 2{instantiated atom of L}
- A = {the set of instantiated operators of O} where O is the set of operators 
- γ(s, a) = (s − effets−(a)) U *effets+*(a) if a ∈ A and a is applicable in s ∈ S 

## Definition 5.4 (Planning Problem)

A problem P for a domain D is a triplet P = (O, s0, g) where: - s0, the initial state, is some state of S; 
- g, the goal, defines a coherent set of instantiated predicates, i.e., world properties must be reached; 
- O is the set of applicable operators. 

## Definition 5.5 (Solution Plan)

A solution plan is defined as a linearization in a space of states. The passage from a state to the other one is made by the application of an action, i.e., an operator completely instantiated. 

Consequently, a solution plan for a planning problem P = (O, s0, g) is a sequence of actions describing a road of an initial state s0 to a final state sn. Such as the goal g Is included in sn. In other words, a plan π is a solution for the problem P if γ(s0,π) satisfy g. 

## Definition 5.6 (Conjecture)

A conjecture is a tuple χ=(A, <, I, C) such as: 
- A ={a0,…, an} is a set of actions. - < *is a set of order constraints on the actions A* like ai<*aj, i.e.*, ai precede aj. 

- I is a set of instantiation constraints on variables of actions A like x=y, x≠y or x=cst such as cst
∈Dx and Dx is the domain of x. 

- C Is a set of causal links such aj p ai ⎯⎯→ such as ai and aj are two actions of A, the order constraint ai<aj exists in <, the property p is an effect of ai and a precondition of aj and finally 