Reasoning over RDF, even in this relatively simple example, is quite hard for a person to follow. A
nontechnical user, who was unsure whether to trust an answer, would have a hard time convincing himself of its validity simply by looking at the rules and the RDF data, and would probably find it impossible to do so with a SQL-like query language. To help with this matter of trust, the system can supply a step-by-step English explanation of any answer that it produces. It can also explain in English why it failed to give an expected answer. The answer to a request such as "show me the authors of papers and their email addresses" is a table saying that, amongst others, "Jeen Broekstra is an author , with email jbroeks@cs.vu.nl , of RDF Query Languages". A step in an explanation is shown in Figure 4.

![0_image_0.png](0_image_0.png)

On the other hand, if we ask whether Adrian Walker is the author of the paper, we get a "No" answer, and a step in the explanation is similar to Figure 4, except that the last two premises are marked as "missing", and the conclusion is marked "not shown". An explanation always starts out with the general justification of an answer, and provides hyperlinks so that one can drill down into more detail as needed. In particular, we could write additional rules so that a rather technical, RDF-based explanation step is preceded by something more suitable for an end user to read. To view and run the example, one can point a browser to (Reeng 2006) and select RDFQueryLangComparison1.

## An Owl Inferencing Test Example

The W3C provides a number of test cases for OWL (W3C 2004). One of these requires the inference that the items in a list are different if they are of rdf:type owl:AllDifferent. One of the rules for this task is shown in Figure 5.