# Grasp And Path-Relinking For Coalition Structure Generation

NICOLA DI MAURO, TERESA M.A. BASILE, STEFANO FERILLI,
AND FLORIANA ESPOSITO
Abstract. **In Artificial Intelligence with Coalition Structure Generation (CSG)**
one refers to those cooperative complex problems that require to find an optimal partition, maximising a social welfare, of a set of entities involved in a system into exhaustive and disjoint coalitions. The solution of the CSG problem finds applications in many fields such as Machine Learning (covering machines, clustering), Data Mining (decision tree, discretization), Graph Theory, Natural Language Processing (aggregation), Semantic Web (service composition),
and Bioinformatics. The problem of finding the optimal coalition structure is NP-complete. In this paper we present a greedy adaptive search procedure
(GRASP) with path-relinking to efficiently search the space of coalition structures. Experiments and comparisons to other algorithms prove the validity of the proposed method in solving this hard combinatorial problem.

## 1. Introduction

An active area of research in Artificial Intelligence regards methods and algorithms to solve complex problems that require to find an optimal partition (maximising a social welfare) of a set of entities involved in a system into exhaustive and disjoint coalitions. This problem has been studied a lot in the area of multi-agent systems (MASs) where it is named coalition structure generation (CSG) problem
(equivalent to the complete set partitioning problem). In particular **it is interesting** to find coalition structures maximizing the sum of the values of the coalitions, that represent the maximum payoff the agents belonging to the coalition can jointly receive by cooperating. A coalition structure is defined as a partition of the agents involved in a system into disjoint coalitions. The problem of finding the optimal coalition structure is N P**-complete [8, 25].**
Coalition generation shares a similar structure with a number of common problems in theoretical computer science and artificial intelligence, such **as in combinatorial auctions; in job shop scheduling, Machine Learning, Data Mining, Graph**
Theory, Natural Language Processing, Semantic Web, and in Bioinformatics. In this paper we will use the term coalition structure generation as a general term to refer to all these grouping problems.

Sometimes there is a time limit for finding a solution, the agents must be **reactive**
and they should act as fast as possible. Hence for the specific task **of CSG it is** necessary to have approximation algorithms able to quickly find solutions that are within a specific factor of an optimal solution. The goal of this paper **is to propose**
a new algorithm for the CSG problem able to quickly find a near optimal solution.

The problem of CSG has been studied in the context of characteristic function games (CFGs) in which the value of each coalition is given by a characteristic 1 arXiv:1103.1157v2 [cs.AI] 9 Mar 2011