which we define as:

![0_image_0.png](0_image_0.png)

Since it is possible to express a belief state formula with every literal (e.g., using (q ∨ ¬q)∧ p to express the belief state where p is true), we assume a reasonably succinct representation, such as a ROBDD (Bryant, 1986). It is quite possible the aggregate states are inconsistent, but many classical planning techniques (such as planning graphs) do not require consistent states. For example, with aggregate states we would compute the belief state distance dist(BS1, BS3) = **dist**(S˜(BS1), S˜(BS3)).

- Choose a Subset of States: We can choose a set of states (e.g., by random sampling) from BS1 and a set of states from BS3, and then compute state distances for all pairs of states from the sets. Upon computing all state distances, we can aggregate the state distances (as we will describe shortly). For example, we might sample both S11 and S12 from BS1 and S31 from BS3, compute dist(S11, S31) and dist(S12, S31), and then aggregate the state distances to define dist(BS1**, BS**3).

- Use All States: We can use all states in BS1 and BS3, and, similar to sampling a subset of states (above), we can compute all distances for state pairs and aggregate the distances.
The former two options for computing belief state distance are reasonably straightforward, given the existing work in classical planning. In the latter two options we compute multiple state distances.

With multiple state distances there are two details which require consideration in order to obtain a belief state distance measure. In the following we treat belief states as if they contain all states because they can be appropriately replaced with the subset of chosen states.

The first issue is that some of the state distances may not be needed. Since each state in BS1 needs to reach a state in BS3, we should consider the distance for each state in BS1 to "a" state in BS3. However, we don't necessarily need the distance for every state in BS1 to "every" state in BS3. We will explore assumptions about which state distances need to be computed in Section 3.1.

The second issue, which arises after computing the state distances, is that we need to aggregate the state distances into a belief state distance. We notice that the popular state distance estimates used in classical planning typically measure aggregate costs of state features (literals). Since we are planning in belief space, we wish to estimate belief state distance with the aggregate cost of belief state features (states). In Section 3.2, we will examine several choices for aggregating state distances and discuss how each captures different types of state interaction. In Section 3.3, we conclude with a summary of the choices we make in order to compute belief state distances.

## 3.1 State Distance Assumptions

When we choose to compute multiple state distances between two belief states BS and BS′,
whether by considering all states or sampling subsets, not all of the state distances are important.

For a given state in BS we do not need to know the distance to every state in BS′ because each state in BS need only transition to one state in BS′. There are two assumptions that we can make about the states reached in BS′ which help us define two different belief state distance measures in terms of aggregate state distances: