dist(BS1, BS3**) = 7**, whereas defining ▽ as maximum gave a distance of five and as summation gave a distance of eight. Compared with overlap, positive interaction tends to under estimate distance, and independence tends to over estimate distance. As we will see during our empirical evaluation (in Section 6.5), accounting for overlap provides more accurate distance measures for many conformant planning domains.

- Negative Interaction of States: Negative interaction between states can appear in our example if transitioning state S11 to state S32 makes it more difficult (or even impossible) to transition state S12 to state S31. This could happen if performing action a5 for S11 conflicts with action a3 for S12. We can say that BS1 cannot reach BS3 if all possible action sequences that start in S11 and S12, respectively, and end in any S ∈ M(BS3) negatively interact.
There are two ways negative interactions play a role in belief state distances. Negative interactions can allow us to prove it is impossible for a belief state BS to reach a belief state BS′, meaning dist(BS, BS′) = ∞, or they can potentially increase the distance by a finite amount. We use only the first, more extreme, notion of negative interaction by computing
"cross-world" mutexes (Smith & Weld, 1998) to prune belief states from the search. If we cannot prune a belief state, then we use one of the aforementioned techniques to aggregate state distances. As such, we do not provide a concrete definition for ▽ to measure negative interaction.

While we do not explore ways to adjust the distance measure for negative interactions, we mention some possibilities. Like work in classical planning (Nguyen et al., 2002), we can penalize the distance measure dist(BS1**, BS**3) to reflect additional cost associated with serializing conflicting actions. Additionally in conditional planning, conflicting actions can be conditioned on observations so that they do not execute in the same plan branch. A distance measure that uses observations would reflect the added cost of obtaining observations, as well as the change in cost associated with introducing plan branches (e.g., measuring average branch cost).

The above techniques for belief state distance estimation in terms of state distances provide the basis for our use of multiple planning graphs. We will show in the empirical evaluation that these measures affect planner performance very differently across standard conformant and conditional planning domains. While it can be quite costly to compute several state distance measures, understanding how to aggregate state distances sets the foundation for techniques we develop in the LUG. As we have already mentioned, the LUG conveniently allows us to implicitly aggregate state distances to directly measure belief state distance.

## 3.3 Summary Of Methods For Distance Estimation

Since we explore several methods for computing belief state distances on planning graphs, we provide a summary of the choices we must consider, listed in Table 1. Each column is headed with a choice, containing possible options below. The order of the columns reflects the order in which we consider the options.

In this section we have covered the first two columns which relate to selecting states from belief states for distance computation, as well as aggregating multiple state distances into a belief state distance. We test options for both of these choices in the empirical evaluation.