different substrates (horizontal axis) can be used to compute belief state distance by aggregating state to state distances under various assumptions (vertical axis). Some of the combinations are not considered because they do not make sense or are impossible. The reasons for these omissions will be discussed in subsequent sections. While there are a wealth of different heuristics one can compute using planning graphs, we concentrate on relaxed plans because they have proven to be the most effective in classical planning and in our previous studies (Bryce & Kambhampati, 2004). We provide additional descriptions of other heuristics like max, sum, and level in Appendix A.

Example: To illustrate the computation of each heuristic, we use an example derived from BTC
called Courteous BTC (CBTC) where a courteous package dunker has to disarm the bomb and leave the toilet unclogged, but some discourteous person has left the toilet clogged. The initial belief state of CBTC in clausal representation is:
κ(BSI ) = arm ∧ clog ∧ (inP1 ∨ inP2) ∧ (¬inP1 ∨¬inP2),
and the goal is:
κ(BSG) = ¬clog ∧¬arm.

The optimal action sequences to reach BSG from BSI are:
Flush, DunkP1, Flush, DunkP2, Flush, and Flush, DunkP2, Flush, DunkP1, Flush.

Thus the optimal heuristic estimate for the distance between BSI and BSG, in regression, is h
∗(BSG) = 5 because in either plan there are five actions.

We use planning graphs for both progression and regression search. In regression search the heuristic estimates the cost of the current belief state w.r.t. the initial belief state and in progression search the heuristic estimates the cost of the goal belief state w.r.t. the current belief state. Thus, in regression search the planning graph(s) are built (projected) once from the possible worlds of the initial belief state, but in progression search they need to be built at each search node. We introduce a notation BSito denote the belief state for which we find a heuristic measure, and BSP
to denote the belief state that is used to construct the initial layer of the planning graph(s). In the following subsections we describe computing heuristics for regression, but they are generalized for progression by changing BSi and BSP appropriately.

In the previous section we discussed two important issues involved in heuristic computation:
sampling states to include in the computation and using mutexes to capture negative interactions in the heuristics. We will not directly address these issues in this section, deferring them to discussion in the respective empirical evaluation sections, 6.4 and 6.2. The heuristics below are computed once we have decided on a set of states to use, whether by sampling or not. Also, as previously mentioned, we only consider sampling states from the belief state BSP because we can implicitly find closest states from BSi without sampling. We only explore computing mutexes on the planning graphs in regression search. We use mutexes to determine the first level of the planning graph where the goal belief state is reachable (via the level heuristic described in Appendix A) and then extract a relaxed plan starting at that level. If the level heuristic is ∞ because there is no level where a belief state is reachable, then we can prune the regressed belief state.

We proceed by describing the various substrates used for computing belief space distance estimates. Within each we describe the prospects for various types of world aggregation. In addition to our heuristics, we mention related work in the relevant areas.