For the CBTC problem we find a relaxed plan from the SGU , as shown in Figure 5 as the bold edges and nodes. Since ¬arm and ¬clog are non mutex at level two, we can use persistence to support ¬clog and DunkP1 to support ¬arm in L
RP
2. In L
RP
1 we can use persistence for inP1, and Flush for ¬clog. Thus, h SG
RP (BSG) = 2 because the relaxed plan is:
ARP
0 = {inP1p, Flush},
E
RP
0 = {ϕ 0(inP1p), ϕ 0(Flush)},
L
RP
1 = {inP1,¬clog},
ARP
1 = {¬clogp, DunkP1},
E
RP
1 = {ϕ 0(¬clogp), ϕ 1(DunkP1)},
L
RP
2 = {¬arm,¬clog}.

The relaxed plan does not use both DunkP2 and DunkP1 to support ¬arm. As a result ¬arm is not supported in all worlds (i.e. it is not supported when the state where inP2 holds is our initial state). Our initial literal layer threw away knowledge of inP1 and inP2 holding in different worlds, and the relaxed plan extraction ignored the fact that ¬arm needs to be supported in all worlds. Even with an SG1 graph, we see similar behavior because we are reasoning with only a single world. A
single, unmodified classical planning graph cannot capture support from all possible worlds - hence there is no explicit aggregation over distance measures for states. As a result, we do not mention aggregating states to measure positive interaction, independence, or overlap.

## 4.3 Multiple Graph Heuristics (Mg)

Single graph heuristics are usually uninformed because the projected belief state BSP often corresponds to multiple possible states. The lack of accuracy is because single graphs are not able to capture propagation of multiple world support information. Consider the CBTC problem where the projected belief state is BSI and we are using a single graph SGU . If DunkP1 were the only action we would say that ¬arm and ¬clog can be reached at a cost of two, but in fact the cost is infinite
(since there is no DunkP2 to support ¬arm from all possible worlds), and there is no strong plan.

To account for lack of support in all possible worlds and sharpen the heuristic estimate, a set of multiple planning graphs Γ is considered. Each γ ∈ Γ is a single graph, as previously discussed.

These multiple graphs are similar to the graphs used by CGP (Smith & Weld, 1998), but lack the more general cross-world mutexes. Mutexes are only computed within each graph, i.e. only sameworld mutexes are computed. We construct the initial layer L
γ 0 of each graph γ with a different state S ∈ M(BSP ). With multiple graphs, the heuristic value of a belief state is computed in terms of all the graphs. Unlike single graphs, we can compute different world aggregation measures with the multiple planning graphs.

While we get a more informed heuristic by considering more of the states in M(BSP ), in certain cases it can be costly to compute the full set of planning graphs and extract relaxed plans. We will describe computing the full set of planning graphs, but will later evaluate (in Section 6.4)
the effect of computing a smaller proportion of these. The single graph SG1is the extreme case of computing fewer graphs.

To illustrate the use of multiple planning graphs, consider our example CBTC. We build two graphs (Figure 6) for the projected BSP . They have the respective initial literal layers:
L
10 = {arm, clog, inP1, ¬inP2} and L
20 = {arm, clog, ¬inP2, inP2}.