describing sets of possible worlds (i.e., initial literal layers), into "labels". The planning graph vertices are the same as those present in multiple graphs, but redundant representation is avoided. For instance an action that was present in all of the multiple planning graphs would be present only once in the LUG and labelled to indicate that it is applicable in a planning graph projection from each possible world. We will describe how to extract heuristics from the LUG that make implicit assumptions about state interaction without explicitly aggregating several state distances.

Ideally, each of the planning graph techniques considers every state in a belief state to compute heuristics, but as belief states grow in size this could become uninformed or costly. For example, the single classical planning graph ignores distinctions between possible states where the heuristic based on multiple graphs leads to the construction of a planning graph for each state. One way to keep costs down is to base the heuristics on only a subset of the states in our belief state. We evaluate the effect of such a sampling on the cost of our heuristics. With a single graph we sample a single state and with multiple graphs and the LUG we sample some percent of the states. We evaluate state sampling to show when it is appropriate, and find that it is dependent on how we compute heuristics with the states.

Standardized Evaluation of Heuristics: An issue in evaluating the effectiveness of heuristic techniques is the many architectural differences between planners that use the heuristics. It is quite hard to pinpoint the global effect of the assumptions underlying their heuristics on performance. For example, GPT is outperformed by MBP–but it is questionable as to whether the credit for this efficiency is attributable to the differences in heuristics, or differences in search engines (MBP uses a BDD-based search). Our interest in this paper is to systematically evaluate a spectrum of approaches for computing heuristics for belief space planning. Thus we have implemented heuristics similar to GPT and MBP and use them to compare against our new heuristics developed around the notion of overlap (multiple world positive interaction and independence). We implemented the heuristics within two planners, the Conformant-**AltAlt** planner (C**AltAlt**) and the Partially-Observable NonDeterministic planner (P OND). **P OND** does handle search with non-deterministic actions, but for the bulk of the paper we discuss deterministic actions. This more general action formulation, as pointed out by Smith and Weld (1998), can be translated into initial state uncertainty. Alternatively, in Section 8.2 we discuss a more direct approach to reason with non-deterministic actions in the heuristics.

External Evaluation: Although our main interest in this paper is to evaluate the relative advantages of a spectrum of belief space planning heuristics in a normalized setting, we also compare the performance of the best heuristics from this work to current state of the art conformant and conditional planners. Our empirical studies show that planning graph based heuristics provide effective guidance compared to cardinality heuristics as well as the reachability heuristic used by GPT
and CFF, and our planners are competitive with BDD-based planners such as MBP and YKA, and GraphPlan-based ones such as CGP and SGP. We also notice that our planners gain scalability with our heuristics and retain reasonable quality solutions, unlike several of the planners we compare against.

The rest of this paper is organized as follows. We first present the C**AltAlt** and **P OND** planners by describing their state and action representations as well as their search algorithms. To understand search guidance in the planners, we then discuss appropriate properties of heuristic measures for belief space planning. We follow with a description of the three planning graph substrates used to compute heuristics. We carry out an empirical evaluation in the next three sections, by describing