room, and lock the window in the current room. Closing a window only works if the window is open, and locking a window only works if the window is closed. A good conformant plan involves moving in one direction closing and locking the window in each room.

The Cube Center domain involves a three-dimensional grid (cube) where there are six actions –
it is possible to move in two directions along each dimension. Each dimension consists of n possible locations. Moving in a direction along which there are no more grid points leaves one in the same position. Using this phenomena, it is possible to localize in each dimension by repeatedly moving in the same direction. Initially it is possible to be at any location in the cube and the goal is to reach the center. A good conformant plan involves localizing in a corner and then moving to the center.

The Rovers domain is a conformant adaptation of the analogous domain of the classical planning track of the International Planning Competition (Long & Fox, 2003). The added uncertainty to the initial state uses conditions that determine whether an image objective is visible from various vantage points due to weather, and the availability of rock and soil samples. The goal is to upload an image of an objective and some rock and soil sample data. Thus a conformant plan requires visiting all of the possible vantage points and taking a picture, plus visiting all possible locations of soil and rock samples to draw samples.

The first five Rovers problems have 4 waypoints. Problems one through four have one through four locations, respectively, at which a desired imaging objective is possibly visible (at least one will work, but we don't know which one). Problem 5 adds some rock and soil samples as part of the goal and several waypoints where one of each can be obtained (again, we don't know which waypoint will have the right sample). Problem 6 adds two more waypoints, keeps the same goals as Problem 5 and changes the possible locations of the rock and soil samples. In all cases the waypoints are connected in a tree structure, as opposed to completely connected.

The Logistics domain is a conformant adaptation of the classical Logistics domain where trucks and airplanes move packages. The uncertainty is the initial locations of packages. Thus, any actions relating to the movement of packages have a conditional effect that is predicated on the package actually being at a location. In the conformant version, the drivers and pilots cannot sense or communicate a package's actual whereabouts. The problems scale by adding packages and cities.

The Logistics problems consist of one airplane, and cities with an airport, a post office, and a truck. The airplane can travel between airports and the trucks can travel within cities. The first problem has two cities and one package that could start at either post office, and the goal is to get the package to the second city's airport. The second problem adds another package at the same possible starting points and having the same destination. The third problem has three cities with one package that could be at any post office and has to reach the third airport. The fourth problem adds a second package to the third problem with the same starting and ending locations. The fifth problem has three cities and three packages, each at one of two of the three post offices and having to reach different airports.

Conditional Problems For conditional planning we consider domains from the literature: Bombin-the-Toilet with sensing BTS, and Bomb-in-the-Toilet with clogging and sensing BTCS. We also extend the conformant Logistics and Rovers to include sensory actions.

The Rovers problem allows for the rover, when it is at a particular waypoint, to sense the availability of image, soil, or rock data at that location. The locations of the collectable data are expressed as one-of constraints, so the rover can deduce the locations of collectable data by failing to sense the other possibilities.