Next, for a single planning graph (SGU ), CAltAlt does reasonably well with the h SG
RP heuristic in the Rovers and Logistics domains, but fails to scale very well on the BT and BTC domains. Rovers and Logistics have comparatively fewer initial worlds than the BT and BTC problems. Moreover the deterministic plans, assuming each initial state is the real state, are somewhat similar for Rovers and Logistics, but mostly independent for BT and BTC. Therefore, approximating a fully observable plan with the single graph relaxed plan is reasonable when plans for achieving the goal from each world have high positive interaction. However, without high positive interaction the heuristic degrades quickly when the number of initial worlds increases.

With multiple planning graphs, CAltAlt is able to perform better in the Rovers domain, but takes quite a bit of time in the Logistics, BT, and BTC domains. In Rovers, capturing distance estimates for individual worlds and aggregating them by some means tends to be better than aggregating worlds and computing a single distance estimate (as in a single graph). In Logistics, part of the reason computing multiple graphs is so costly is that we are computing mutexes on each of the planning graphs. In BT and BTC, the total time increases quickly because the number of planning graphs, and number of relaxed plans for every search node increase so much as problems get larger.

Comparing the two multiple graph heuristics6in CAltAlt namely hMG
m−RP and hMG
RP U , we can see the effect of our choices for state distance aggregation. The hMG
m−RP relaxed plan heuristic aggregates state distances, as found on each planning graph, by taking the maximum distance. The hMG
RP U unions the relaxed plans from each graph, and counts the number of actions in the unioned relaxed plan. As with the single graph relaxed plan, the hMG
m−RP relaxed plan essentially measures one state to state distance; thus, performance suffers on the BT and BTC domains. However, using the unioned relaxed plan heuristic, we capture the independence among the multiple worlds so that we scale up better in BT and BTC. Despite the usefulness of the unioned relaxed plan, it is costly to compute and scalability is limited, so we turn to the LUG version of this same measure.

With the LUG, we use the h LUG(F X)
RP heuristic in CAltAlt. This heuristic uses a LUG with full cross-world mutexes (denoted by FX). As in the similar hMG
RP U heuristic, measuring overlap is important, and improving the speed of computing the heuristic tends to improve the scalability of CAltAlt. While CAltAlt is slower in the Rovers and BTC domains when using the LUG, we note that it is because of the added cost of computing cross-world mutexes - we are able to improve the speed by relaxing the mutexes, as we will describe shortly.

## 6.2 Mutexes

Mutexes are used to help determine when a belief state is unreachable. Mutexes improve the pruning power of heuristics by accounting for negative interactions. The mutexes are only used to improve our heuristics, so it is reasonable to compute only a subset of the mutexes. We would like to know which mutexes are the most cost effective because the number of possible mutexes we can find is quite large.

We can use several schemes to compute a subset of the mutexes. The schemes combine different types of mutexes with types of cross-world checking. The mutex types are: computing no mutexes
(NX), computing only static interference mutexes (StX), computing (StX) plus inconsistent support and competing needs mutexes - dynamic mutexes (DyX), and computing (DyX) plus induced mutexes - full mutexes (FX). The cross-world checking (see appendix B) reduction schemes are: