computing mutexes across same-worlds (SX) and computing mutexes across pairs of worlds in the intersection (conjunction) of element labels (IX).

Table 4 shows that within CAltAlt, using the relaxed plan heuristic and changing the way we compute mutexes on the LUG can drastically alter performance. Often, the cross-world mutexes are so numerous that building the LUG takes too much time. To see if we could reduce graph construction overhead without hindering performance, we evaluated h LUG
RP when the LUG is built
(a) considering all cross-world relations, for the schemes (NX), (StX), (DyX), and (FX); and (b) same-world relations for the schemes (DyX-SX) and (FX-SX), and (c) cross-world relations for all possible worlds pairs in the intersection of element's labels (DyX-IX) and (FX-IX).

The results show that simpler problems like BT and BTC do not benefit as much from advanced computation of mutexes beyond static interference. However, for the Rovers and Logistics problems, advanced mutexes play a larger role. Mainly, interference, competing needs, and inconsistent support mutexes are important. The competing needs and inconsistent support mutexes seem to have a large impact on the informedness of the guidance given by the LUG, as scalability improves most here. Induced mutexes don't improve search time much, and only add to graph computation time. A possible reason induced mutexes don't help as much in these domains is that all the actions have at most two effects, an unconditional and conditional effect. Reducing cross-world mutex checking also helps quite a bit. It seems that only checking same-world mutexes is sufficient to solve large problems. Interestingly, the MG graphs compute same-world interference, competing needs, and inconsistent support mutexes within each graph, equating to the same scenario as (DyXSX), however, the LUG provides a much faster construction time, evidenced by the LUG's ability to out-scale MG.

## 6.3 **P Ond**

We show the total time and the number of expanded nodes for **P OND** solving the conformant problems (including Ring and Cube Center) in Table 5, and for **P OND** solving the conditional problems in Table 6. As with CAltAlt we show the total time and number of expanded nodes for each test. We also add the hMG
s−RP heuristic, not implemented in CAltAlt, that takes the summation of the values of relaxed plans extracted from multiple planning graphs. We do not compute mutexes on any of the planning graphs used for heuristics in **P OND** mainly because we build planning graphs for each search node. We proceed by first commenting on the performance of **P OND**, with the different heuristics, in the conformant domains, then discuss the conditional domains.

In the conformant domains, **P OND** generally does better than CAltAlt. This may be attributed in part to implementation-level details. **P OND** makes use of an existing (highly optimized) BDD
package for belief state generation in progression, but as previously mentioned, CAltAlt relies on a less optimized implementation for belief state generation in regression. As we will see in the next section, regression planners that employ a more sophisticated implementation perform much better, but could still benefit from our heuristics. Aside from a few differences that we will mention, we see similar trends in the performance of the various heuristics in both CAltAlt and **P OND**. Namely, the NG and SG heuristics have limited ability to help the planner scale, the MG heuristics help the planner scale better but are costly, and the LUG provides the best scalability. The difference between the MG and the LUG are especially pronounced in Cube Center and Ring, where the size of the initial belief state is quite large as the instances scale. Interestingly in Ring, breadth first search and the single graph relaxed plan are able to scale due to reduced heuristic computation time