
## Appendix B. Cross-World Mutexes

Mutexes can develop not only in the same possible world but also between two possible worlds, as described by Smith and Weld (1998). Cross-world mutexes are useful to capture negative interactions in belief state distance measures (mentioned in Section 3). The representation of crossworld mutexes requires another generalization for the labelling of mutexes. Same world mutexes require keeping only one label for the mutex to signify all same possible worlds for which the mutex holds. The extended representation keeps a pair of labels, one for each element in the mutex; if x in possible world S is mutex with x
′in possible world S
′, we denote the mutex as the pair
(
ˆℓk(x) = S, ˆℓk(x
′) = S
′).

We can compute cross-world mutexes between several worlds of elements x and x
′. For example, if ℓk(x) = S1∨S2∨S3 and ℓk(x
′) = S2∨S3, then to check for all cross-world mutexes we need to consider mutexes for the world pairs (S1, S2),(S1, S3),(S2, S2),(S2, S3),(S3, S2), and (S3, S3).

We can also check for mutexes in the intersection of the element labels ℓk(x) ∧ ℓk(x
′) = S2 ∨ S3, meaning the only cross world pairs we check for mutexes are (S2, S2),(S2, S3),(S3, S2), and (S3, S3).

We can say that a formula f is reachable from our projected belief state BSP , when considering cross-world mutexes, if for every pair of states in BSP , f is reachable. For a pair of states S and S
′, f is reachable if S ∧ S
′|= ℓ
∗
k
(f) and for every pair of constituents Sˆ′′, Sˆ′′′ ∈ ˆf such that S |= ℓ
∗ k
(Sˆ′′) and S
′|= ℓ
∗ k
(Sˆ′′′), there are no two literals in either Sˆ′′ or Sˆ′′′ that are same-world mutex when S = S
′, and there is not a mutex between literals in Sˆ′′ and Sˆ′′′, across the respective worlds S and S
′ when S 6= S
′. There is a mutex between a pair literals l and l
′, respectively from Sˆ′′ and Sˆ′′′ if there is a mutex (
ˆℓk(l),
ˆℓk(l
′)) such that S |= ˆℓk(l) and S
′|= ˆℓk(l
′).

The computation of cross-world mutexes requires changes to some of the mutex formulas, as outlined next. The major change is to check, instead of all the single possible worlds S, all pairs of possible worlds S and S
′for mutexes.

Action Mutexes: The action mutexes can now hold for actions that are executable in different possible worlds.

- **Interference** Interference mutexes do not change for cross-world mutexes, except that there is a pair of labels where (ˆℓk(a) = BSP ,
ˆℓk(a
′) = BSP ), instead of a single label.

- **Competing Needs** Competing needs change mutexes for cross-world mutexes because two actions a and a
′, in worlds S and S
′respectively, could be competing. Formally, a crossworld competing needs mutex ((
ˆℓk(a) = S, ˆℓk(a
′) = S
′) exists between a and a
′in worlds S
and S
′if:
∃l∈ρ e(a),l′∈ρ e(a
′)(
ˆℓk(l) = S, ˆℓk(l
′) = S
′)
Effect Mutexes: The effect mutexes can now hold for effects that occur in different possible worlds.

- **Interference** Effect interference mutexes do not change for cross-world mutexes, except that there is a pair of labels where (ˆℓk(ϕ i(a**)) =** BSP ,
ˆℓk(ϕ j(a
′**)) =** BSP ), instead of a single label.