The main differences between our formulation of AO* and that of Nilsson (1980) are that we do not allow cycles in the search graph, we update the costs of nodes with an average rather than a summation, and use a weighted estimate of future cost. The first difference is to ensure that plans are strong (there are a finite number of steps to the goal), the second is to guide search toward plans with lower average path cost, and the third is to bias our search to trust the heuristic function. We define our plan quality metric (maximum plan path length) differently than the metric our search minimizes for two reasons. First, it is easier to compare to other competing planners because they measure the same plan quality metric. Second, search tends to be more efficient using the average instead of the maximum cost of an action's children. By using average instead of maximum, the measured cost of a plan is lower - this means that we are likely to search a shallower search graph to prove a solution is not the best solution.

Conformant planning, using actions without observations, is a special case for AO* search, which is similar to A* search. The hyper-edges that represent actions are singletons, leading to a single successor belief state. Consider the BTC problem (BTCS without the DetectMetal action)
with the future cost (heuristic value) set to zero for every search node. We show the search graph in Figure 2 for this conformant example as well as a conditional example, described shortly. We can expand the initial belief state by progressing it over all applicable actions. We get:
B1 = {BS10} = Progress(BSI , DunkP1)
= {(inP1 ∧¬inP2 ∧ clog ∧¬arm) ∨ (¬inP1 ∧ inP2 ∧ clog ∧ arm)}
and B3 = {BS20} = Progress(BSI , DunkP2)
= {(inP1 ∧¬inP2 ∧ clog ∧ arm) ∨ (¬inP1 ∧ inP2 ∧ clog ∧¬arm)}.

Since ¬clog already holds in every state of the initial belief state, applying Flush to BSI leads to BSI creating a cycle. Hence, a hyper-edge for Flush is not added to the search graph for BSI . We assign a cost of zero to BS10 and BS20, update the internal nodes of our best solution, and add DunkP1 to the best solution rooted at BSI (whose cost is now one).

We expand the leaf nodes of our best solution, a single node BS10, with all applicable actions.

The only applicable action is Flush, so we get:
B3 = {BS30} = Progress(BS10, Flush)
= {(inP1 ∧¬inP2 ∧¬clog ∧¬arm) ∨ (¬inP1 ∧ inP2 ∧¬clog ∧ arm)}.

We assign a cost of zero to BS30 and update our best solution. We choose Flush as the best action for BS10 (whose cost is now one), and choose DunkP2 as the best action for BSI (whose cost is now one). DunkP2 is chosen for BSI because its successor BS20 has a cost of zero, as opposed to BS10 which now has a cost of one.

Expanding the leaf node BS20 with the only applicable action, Flush, we get:
B4 = {BS40} = Progress(BS20, Flush)
= {(¬inP1 ∧ inP2 ∧¬clog ∧arm) ∨ (inP1 ∧¬inP2 ∧¬clog ∧¬ arm)}.

We update BS40 (to have cost zero) and BS20 (to have a cost of one), and choose Flush as the best action for BS20. The root node BSI has two children, each with cost one, so we arbitrarily choose DunkP1 as the best action.

We expand BS30 with the relevant actions to get BSG with the DunkP2 action. DunkP1 creates a cycle back to BS10 so it is not added to the search graph. We now have a solution where all leaf nodes are terminal. While it is only required that a terminal belief state contains a subset of the