# Sppam - Statistical Preprocessing Algorithm An Approach For The Classification Of Multiple Correlated Data Tiago Silva, Ines Dutra ˆ

CRACS & INESC-Porto LA
Faculdade de Ciencias, Universidade do Porto ˆ
Rua do Campo Alegre, 1021 4169-007 Porto PORTUGAL
tiagosilva@inbox.com, ines@dcc.fc.up.pt

## Abstract

Most machine learning tools work with a single table where each row is an instance and each column is an attribute. Each cell of the table contains an attribute value for an instance. This representation prevents one important form of learning, which is, classification based on groups of correlated records, such as multiple exams of a single patient, internet customer preferences, weather forecast or prediction of sea conditions for a given day. To some extent, relational learning methods, such as inductive logic programming, can capture this correlation through the use of intensional predicates added to the background knowledge. In this work, we propose SPPAM, an algorithm that aggregates past observations in one single record. We show that applying SPPAM to the original correlated data, before the learning task, can produce classifiers that are better than the ones trained using all records.

Keywords: multi-relational data, classification, data preprocessing.

## 1 Introduction

Machine learning techniques have been successfully applied to various domains. However there is a lack of formal methodology and application of machine learning tools to datasets that are characterized by subgroups of correlated records. Examples are medical records with multiple exams of a single patient, internet customer preferences, weather forecast and prediction of sea conditions, among others. Despite the fact that there are many applications that fall into this category, there is also a lack of available datasets with this characteristic in the main UCI machine learning repository (http://archive.ics.uci.edu/ml/).

Machine learning tools usually learn classifiers from a single table where each row is an instance and each column is an attribute. Each cell of the table contains an attribute value for an instance. Most of these tools treat each row of this table as independent from each other, which prevents one important form of learning based on groups of correlated records. Tools based on first order logic (inductive logic programming) can partially overcome this problem because they can do multirelational learning. But first order rules in the form of intensional predicates need to be added to the background knowledge, in order to code the multi-relational meaning intended by the observer [1].

When dealing with data that have this multi-relational characteristic, one additional problem arises when using crossvalidation. Ideally, records that belong to the same observation period need to be manually separated in a way that all records of a certain period falls into just one fold. Machine learning tools like WEKA [2], for example, do not allow training based on pre-defined folds (unless when using the percentage split training option).

In this work, we propose a general method that connects records that are correlated (either through the same location or observation period). To the best of our knowledge, this is the first work that tackles this problem.

We propose SPPAM (Statistical PreProcessing AlgorithM), an algorithm that aggregates past correlated observations in one single record. We apply SPPAM to two datasets of surf conditions. Our task is to learn a classifier that predicts well if a certain beach is adequate for surfing in a certain day.

We perform our experiments using the WEKA machine learning tool and compare the performance of various WEKA algorithms trained on the original datasets and on the SPPAMtransformed datasets. We show that applying SPPAM to the original correlated data, before the learning task, can produce classifiers that are better than the ones trained using the original datasets with all records.

Some work has been done on characterizing relations from weather observations and forecasts using machine learning techniques. For example, Ingsrisawan *et al.* used support vector machines, decision trees and neural networks to develop models to predict rainfall occurrences in Thailand [4]. Lai et al. proposed a preprocessing technique for weather data in order to predict temperature and weather conditions [5].

Williams*et al.* proposed the use of Random Forests to predict and classify storm forecastings [3]. However, we are not only interested in temporal patterns nor pure weather forecast. Our goal is to provide a generic preprocessing technique that increase the classification task's performance for every suitable dataset.

This paper is organized as follows. In Section 2 we describe the SPPAM algorithm. In Section 3 we discuss the methodology used to run our experiments and present the