datasets. In Section 4, we present and discuss our results.

Finally, in Section 5 we draw our conclusions and give perspectives of future work.

## 2 An Approach To Classify Multiple Correlated Data

SPPAM is a two-step algorithm that captures the hierarchical aspect of learning from a dataset with multiple records for the same observation period (or location). The first step is to separate and consolidate records that belong to the same time/location interval. The user needs to provide the name of the attribute that will be used to perform this separation and the name of the class attribute. We also assume that each record has a unique identifier. We use a transformation that maps several records into just one record along with a transformation on the original attributes. The algorithm can be seen in Algorithm 1.

## Data:

Dataset, *// original dataset* Result:
Out, *// original dataset transformed* Initialize a new empty dataset Out; Read *Dataset*;
foreach Attribute a in *Dataset* do if a *has type Numeric* **then**
create Attributes a-Maximum, a-Minimum, a-Average and a-Last on Out; end else if a *is Nominal* **then**
create Attributes a-Frequency for each nominal value and a-Last on Out; end else copy a to Out; end end Group correlated records according to the user provided field; foreach *Group* i do read each individual attribute value A;
if *A has type String or is the ID* **then**
copy A to Out; end if *A has type numeric* **then**
calculate Maximum, Minimum, Average and Last values among all values of A for group i; copy them to Out; end if *A is nominal* **then**
copy frequency and the last value of A in group i to Out; end Take the value of the class variable of last instance of Group i; Copy it to Out to complete the record end Algorithm 1: The SPPAM algorithm This basic version of the algorithm maps groups of records of each observation to just one record by computing aggregates for the values of the attributes. But what to do with the class variable? In this algorithm, we keep the last class value of the group (i.e., the most recent observation).

Figures 1 and 2 illustrate an example of this transformation.

@ATTRIBUTE Date String
@ATTRIBUTE Wind_Knots numeric @ATTRIBUTE Wind_Dir {N, NE, E, SE, S, SW, W, NW} @ATTRIBUTE Surf {0,1}
@DATA
18-11-2010,15.6,SE,0 18-11-2010,9.7,SE,0 18-11-2010,3.9,SE,0 18-11-2010,5.8,NE,0 19-11-2010,11.7,NE,0 19-11-2010,15.6,NE,0 19-11-2010,13.6,E,1 19-11-2010,15.6,E,1 Figure 1: Original dataset
@ATTRIBUTE Date STRING @ATTRIBUTE Wind_Knots_MAX NUMERIC
@ATTRIBUTE Wind_Knots_MIN NUMERIC
@ATTRIBUTE Wind_Knots_AVG NUMERIC @ATTRIBUTE Wind_Knots_LAST NUMERIC @ATTRIBUTE Wind_Dir_N_PERC NUMERIC
@ATTRIBUTE Wind_Dir_NE_PERC NUMERIC
@ATTRIBUTE Wind_Dir_E_PERC NUMERIC @ATTRIBUTE Wind_Dir_SE_PERC NUMERIC @ATTRIBUTE Wind_Dir_S_PERC NUMERIC @ATTRIBUTE Wind_Dir_SW_PERC NUMERIC @ATTRIBUTE Wind_Dir_W_PERC NUMERIC @ATTRIBUTE Wind_Dir_NW_PERC NUMERIC
@ATTRIBUTE Wind_Dir_LAST {N, NE, E, SE, S, SW, W, NW}
@ATTRIBUTE Surf {0,1} @DATA 18-11-2010,15.6,3.9,8.75,5.8,0.0,25.0,0.0,75.0,0.0,0.0,0.0,0.0,NE,0 19-11-2010,15.6,11.7,14.13,15.6,0.0,50.0,50.0,0.0,0.0,0.0,0.0,0.0,E,1 Figure 2: SPPAM-transformed dataset The original dataset (Figure 1) shows an example of two days of observation of weather and sea conditions for surf practice with 4 attributes and 8 instances. The first attribute Date is of type String and will be our aggregation pivot attribute, the second is of type numeric, the third attribute is nominal (with eight possible values) and the last attribute (the class) is binary. Our goal is to aggregate all observations within a day in one single record.

The transformed dataset for this example has 2 data rows for two observation days (18-11-2010 and 19-11-2010), each with 15 attributes. The first attribute is the date. The next 4 attributes are numeric values corresponding to the maximum, minimum, average and last values of the Wind *Knots* attribute. The following 8 numeric values correspond to the frequencies of each nominal value of the attribute Wind Dir.

The following attribute (14) is a nominal value representing the last observed value for the Wind Dir attribute. The last attribute is the last value of the class attribute for the group. The number of instances of the transformed dataset drops to only 2 given that we had only 2 complete days of observation in the original table. For attribute 2, Wind *Knots*, the first day has maximum value of 15.6, minimum 3.9 and average of 8.75 and the last obtained value 5.8. The same would repeat for another hypothetical numeric attribute. Attribute Wind Dir in the original dataset will unfold in nine attributes