on the transformed data, because it is nominal and it has eight values plus the last observed value. The first unfolded value corresponds to the frequency of occurrence of the first value on that observation group. The second, to the frequency of occurrence of the second value and so on.

The total number of attributes on the transformed dataset is given by the equation

$$1+s+4n+\sum_{i=1}^{w}\left(V\left(w_{i}\right)+1\right)\tag{1}$$

where s is the number of String attributes on the original dataset, n is the number of numeric attributes on the original dataset, w is the number of nominal attributes and the function *V(w)* is the number of values of the nominal attribute w, for all non-class attributes.

The number of records on the transformed dataset is equal to the number of different unique ids on the original datasets, in our example the id is the date attribute.

After this preprocessing task, the second step is to feed the new table (transformed dataset) to a machine learning algorithm, like any other dataset.

Although we are dealing with meteorological data, the method above described is fully applicable to any kind of relational data where various records are related to the same individual.

## 3 Methodology And Applications

We applied our algorithm to two datasets. The first one is the Surf - Praia Grande dataset which has 10 attributes, 5 of them numeric, 4 nominal and 1 string. This dataset contains four daily observations of wind and sea conditions taken from the Praia Grande beach, Portugal, between November 18th 2010 and January 6th 2011, in the total of 192 instances. The 10 attributes are: date, hour, total sea height, wave height, wave direction, wind wave height, wind speed, wind direction, water temperature and wave set quality to practice surf. This last attribute is our class which can have 2 different values: 0 and 1, where 0 means that the weather and sea conditions are not good for surf practice, and 1 means that there are good conditions to surf.

The second dataset is the Surf - Aljezur and it has the same structure (data were collected at the same period of time as Praia Grande). The attributes and number of instances are the same as the Surf - Praia Grande.

Table 3 shows the detailed structure of the original datasets to be transformed by the SPPAM algorithm. A summary of the transformations on both datasets is shown in table 2.

For both datasets, the number of attributes generated by SPPAM is 44 (which follows from equation 1) and the number of instances is 48 (the number of different observation days).

After applying our algorithm to the datasets, we performed learning experiments using the WEKA tool, developed at Waikato University, New Zealand [2]. The experiments were performed in WEKA using the Experimenter module, where we set several parameters, including the statistical significance test and confidence interval, and the algorithms we wanted to use (we used OneR as reference, ZeroR, PART,

| Aljezur attributes Attribute   | Type            | Values                     |
|--------------------------------|-----------------|----------------------------|
| Date                           | String          |                            |
| Hour                           | Nominal         | 0, 6, 12, 18               |
| Wave Total                     | Numeric         |                            |
| Wave                           | Numeric         |                            |
| Wave Direction                 | Nominal         | N, NE, E, SE, S, SW, W, NW |
| Vaga                           | Numeric         |                            |
| Wind Speed                     | Numeric         |                            |
| Wind Direction                 | Nominal         | N, NE, E, SE, S, SW, W, NW |
| Water Temperature              | Numeric         |                            |
| Sets                           | Nominal (Class) | 0,1                        |

 $\mathbf{a}\ \mathbf{G a}\ \mathbf{G a}\ \mathbf{G a}\ \mathbf{G a}\ \mathbf{G a}\ \mathbf{G a}$  $\mathbf{\frac{\frac{117\left(61\%\right)}{30\left(62\%\right)}}{\frac{144\left(75\%\right)}{39\left(81\%\right)}}}$

Table 2: Original and SPPAM-transformed datasets summary

Dataset # Instances Class = 0 **Class = 1**

Sintra 192 75 (39%) 117 (61%)

Sintra SPPAM 48 18 (38%) 30 (62%) Aljezur 192 48 (25%) 144 (75%) Aljezur SPPAM 48 9 (19%) 39 (81%)

J48, SimpleCart, DecisionStump, Random Forests, SMO,
Naive Bayes, Bayes with TAN, NBTree and DTNB). The WEKA experimenter produces a table with the performance metrics of all algorithms with an indication of statistical differences, using one of the algorithms as a reference. The significance tests were performed using standard corrected t-test with a significance level of 0.01. The parameters used for the learning algorithms are the WEKA defaults. For all experiments we used 10-fold stratified cross-validation and report results for the test sets.

## 4 Results

We compared the results obtained in WEKA using our preprocessing method SPPAM with the results obtained with the original datasets. In tables 3 and 4, we present the performance obtained by the WEKA algorithms for both the original dataset and the SPPAM transformed dataset for Surf -
Praia Grande and Surf - Aljezur. We show the results obtained for Percentage of Correctly Classified Instances (CCI), Kappa Statistic (Kappa), Precision (Precis.), Recall and F-Measure (F-Meas.). We show the performance for each class and the averaged performance for both classes. Our best results with SPPAM are highlighted on both tables. We also present charts showing the average performance gain between the correctly classified instances average for the SPPAM datasets and for the original datasets on all classification algorithms.

## 4.1 Praia Grande Dataset Results

For this particular dataset, our best results were obtained using Bayesian Networks (using the TAN and K2 search algorithms), Naive Bayes and DTNB, as shown in Table 3.

Naive Bayes is the algorithm that yields the best performance when training with the SPPAM-transformed datasets, for every metric.

In Figure 3 we show graphically the differences between the correctly classified instances percentage average for the original dataset and the SPPAM-preprocessed dataset for the Praia Grande data for all the machine learning algorithms we tested. The values are in percentage.