# Language, Emotions, And Cultures: Emotional Sapir-Whorf Hypothesis

Leonid Perlovsky Harvard University and the AFRL, E-mail: leonid@seas.harvard.edu Abstract - An emotional version of Sapir-Whorf hypothesis suggests that differences in language emotionalities influence differences among cultures no less than conceptual differences. Conceptual contents of languages and cultures to significant extent are determined by words and their semantic differences; these could be borrowed among languages and exchanged among cultures. Emotional differences, as suggested in the paper, are related to grammar and mostly cannot be borrowed. Conceptual and emotional mechanisms of languages are considered here along with their functions in the mind and cultural evolution. In language evolution from primordial undifferentiated animal cries conceptual contents increase, emotional reduced. This leads to a fundamental contradiction in human mind. Reduced emotionality of vocalization is necessary for language evolution. But "too low" emotionality makes language "irrelevant to life," disconnected from sensory-motor experience. Neural mechanisms of these processes are suggested as well as their mathematical models: the knowledge instinct, the language instinct, the dual model connecting language and cognition, dynamic logic, neural modeling fields. Mathematical results are related to cognitive science, linguistics, and psychology. Experimental evidence and theoretical arguments are discussed. Approximate equations for evolution of human minds and cultures are obtained. The knowledge instinct operating in the mind hierarchy leads to mechanisms of differentiation and synthesis determining ontological development and cultural evolution. The mathematical model identifies three types of cultures: "conceptual" pragmatic cultures, in which emotionality of language is reduced and differentiation overtakes synthesis resulting in fast evolution at the price of uncertainty of values, self doubts, and internal crises; "traditional-emotional" cultures where differentiation lags behind synthesis, resulting in cultural stability at the price of stagnation; and "multi-cultural" societies combining fast cultural evolution and stability. Unsolved problems and future theoretical and experimental directions are discussed. Keywords: language, cognition, emotions, knowledge instinct, language instinct, dynamic logic, mind, hierarchy, dual model, Sapir-Whorf Hypothesis, inner form, outer form

## 1 1. Emotional Sapir-Whorf Hypothesis

Benjamin Whorf (Whorf, 1956) and Edward Sapir (Sapir, 1985) in a series of publications in the 1930s researched an idea that the way people think is influenced by the language they speak. Although there was a long predating linguistic and philosophical tradition, which emphasized influence of language on cognition (Bhartrihari, IVCE/1971; Humboldt, 1836/1967; Nietzsche, 1876/1983), this is often referenced as Sapir-Whorf hypothesis (SWH). Linguistic evidence in support of this hypothesis concentrated on conceptual contents of languages. For example, words for colors influence color perception (Roberson, Davidoff, & Braisbyb, 1999; Winawer, 