language. Cognitive models contain cultural meanings separate from language (Perlovsky, 2009), but transmission of cognitive models from generation to generation is mostly facilitated by language. Cultural habits and visual arts can preserve and transfer meanings, but they contain a minor part of cultural wisdom and meanings comparative to those transmitted through the language. Language models are major containers of cultural knowledge shared among individual minds and collective culture.

The arguments in the previous two paragraphs suggest that an important step toward understanding cultural evolution is to identify mechanisms determining changes of the language sounds. As discussed below, changes in the language sounds are controlled by grammar. In inflectional languages, affixes, endings, and other inflectional devices are fused with sounds of word roots. Pronunciation-sounds of affixes are controlled by few rules, which persist over thousands of words. These few rules are manifest in every phrase. Therefore every child learns to pronounce them correctly. Positions of vocal tract and mouth muscles for pronunciation of affixes (etc.) are fixed throughout population and are conserved throughout generations. Correspondingly, pronunciation of whole words cannot vary too much, and language sound changes slowly. Inflections therefore play a role of "tail that wags the dog" as they anchor language sounds and preserve meanings. This, I think is what Humboldt (1836/1967) meant by "firmness" of inflectional languages. When inflections disappear, this anchor is no more and nothing prevents the sounds of language to become fluid and change with every generation. 

This has happened with English language after transition from Middle English to Modern English (Lerer, 2007), most of inflections have disappeared and sound of the language started changing within each generation with this process continuing today. English evolved into a powerful tool of cognition unencumbered by excessive emotionality. English language spread democracy, science, and technology around the world. This has been made possible by conceptual differentiation empowered by language, which overtook emotional synthesis. But the loss of synthesis has also lead to ambiguity of meanings and values. Current English language cultures face internal crises, uncertainty about meanings and purposes. Many people cannot cope with diversity of life. Future research in psycholinguistics, anthropology, history, historical and comparative linguistics, and cultural studies will examine interactions between languages and cultures. Initial experimental evidence suggests emotional differences among languages consistent with our hypothesis (Guttfreund, 1990; Harris, Ayçiçegi, & Gleason, 2003). 

Neural mechanisms of grammar, language sound, related emotions-motivations, and meanings hold a key to connecting neural mechanisms in the individual brains to evolution of cultures. Studying them experimentally is a challenge for future research. It is not even so much a challenge, because experimental methodologies are at hand; they just should be applied to these issues. The following sections develop mathematical models based on existing evidence that can guide this future research. 

## 3. Hierarchy Of The Mind And Cultural Dynamics

This section summarizes mathematical models of the mind mechanisms corresponding to the discussion in the previous section. These models are based on the available experimental evidence and theoretical development by many authors summarized in (Perlovsky, 1987; 1994; 1997; 1998; 2000; 2006a,b,c; 2007b; 1009a,b; 1010d,f,g,m; Perlovsky, Plum, Franchi, Tichovolsky, Choi, & Weijers, 1997) and it corresponds to recent neuro-imaging data (Bar et al, 