Observation 1. If the input of Add-to-inf-sub satisfies the formula represented by the low child of any node is not equivalent to the high child, then its output also satisfies this condition. We can prove it by induction. So we only need to delete the redundant nodes from the output of Add-to-inf-sub in the algorithm Reduce. 

As the algorithm Add-to-inf plays a key role in this paper, we give an example to show how it works. 

Example 1. Let us consider the ROBDD-0 in Figure 2. For simplicity, we omit the implied literals table here, and the nodes table of ROBDD is showed in Figure 6(a). First, we compute the maximal set of implied literals for each node in ROBDD. Then Add-to-inf-sub(v10) is called. As both children of v10 are non-False, Add-to-inf-sub(v9) 
is called on the Line 14. Similarly, Add-to-inf-sub(v7) is called on the Line 14. After running Lines 5-9, v′ = v1. Then u is assigned as 〈{¬y1, ¬y2}〉 and it is put into G2. L(lo(u)) is assigned as {¬y2} on Line 15, this means that vIV is generated. Then Add-to-inf-sub(v5) is called on the Line 16. Similarly, 〈{¬y1, y2}〉 and it is put into G2, L(hi(u)) is assigned as {y2} on Line 17, this means that vII is generated. Then 〈x2, IV, II, {¬y1}〉 is put into G2. Back to the calling of Add-to-inf-sub(v10), L(lo(u)) is assigned as {¬y1} on Line 15, this means that vVI is generated. Similarly, L(hi(u)) is assigned as {y1} on Line 17 and vV is generated. Finally, Add-to-inf-sub(v10) returns 〈x1, VI, V, 
∅〉, which is the root of the resulting OBDD-∞ (its nodes table is showed in Figure 6(c), and it is showed in Figure 6(d)). On Lines 24, we run Reduce on the OBDD-∞, and the ROBDD-∞ in Figure 2 is generated. 

| (a) The nodes table of ROBDD-0   |       |     |      |    |            |
|----------------------------------|-------|-----|------|----|------------|
| ID                               | var   | low | high | L  | L∞         |
| 10                               | x1    | 9   | 8    | ∅  | ∅          |
| 9                                | x2    | 7   | 5    | ∅  | {¬y1}      |
| 8                                | x2    | 6   | 4    | ∅  | {y1}       |
| 7                                | y1    | 3   | 0    | ∅  | {¬y1, ¬y2} |
| 6                                | y1    | 0   | 3    | ∅  | {y1, ¬y2}  |
| 5                                | y1    | 2   | 0    | ∅  | {¬y1, y2}  |
| 4                                | y1    | 0   | 2    | ∅  | {y1, y2}   |
| 3                                | y2    | 1   | 0    | ∅  | {¬y2}      |
| 2                                | y2    | 0   | 1    | ∅  | {y2}       |
| 1                                | True  | -   | -    | ∅  | ∅          |
| 0                                | False | -   | -    | -  | -          |

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

| ID   | var   | low   | high   | L     |
|------|-------|-------|--------|-------|
| VII  | y1    | VI    | V      | ∅     |
| VI   | y2    | IV    | II     | {¬y1} |
| V    | y2    | III   | I      | {y1}  |
| IV   | y2    | -     | -      | {¬y2} |
| III  | y2    | -     | -      | {¬y2} |
| II   | y2    | -     | -      | {y2}  |
| I    | y2    | -     | -      | {y2}  |

Figure 6. An example about the algorithm Add-to-inf. 

Proposition 5. Given any two number i < j, ROBDD-i is not at least as succinct as ROBDD-j. 

Proof. According to Definition 7, we just need to provide a counterexample here. Let us consider the formula below over the linear order x1 < … < x i + 1 < x1, 1 < … < x1, i+1 < … < xn, 1 < … < xn, i + 1:
1 1,1 1 1, 1 ,1 , 1 (( ) ( )) (( ) ( )). i n n n *xx xx xx xx* ↔ ∧∧ ↔ ∧∧ ↔ ∧∧ ↔ **L LL** + + n i The size of ROBDD-i representing this formula is exponential, while the size of ROBDD-(i + 1) is polynomial. 

And ROBDD-(i + 1) is as same as ROBDD-j. ■
Now we know that ROBDD-∞ is strictly more succinct than ROBDD by the above two propositions, then a question occurs: is it possible that ROBDD-∞ has a linear size as ROBDD for some kind of knowledge bases. The following proposition, which is useful for proving that the size of ROBDD-i (0 < i ≤ ∞) corresponding to some formula ϕ is exponential in the size of ϕ, will answer this question. 

| (b) The cache G2 G2   |      |     |      |            |
|-----------------------|------|-----|------|------------|
| ID                    | var  | low | high | L          |
| 10                    | x1   | VI  | V    | ∅          |
| 9                     | x2   | IV  | II   | {¬y1}      |
| 8                     | x2   | III | I    | {y1}       |
| 7                     | True | -   | -    | {¬y1, ¬y2} |
| 6                     | True | -   | -    | {y1, ¬y2}  |
| 5                     | True | -   | -    | {¬y1, y2}  |
| 4                     | True | -   | -    | {y1, y2}   |
