frequency measurement for COPD patients from the wearable device
- no-silent, when it is requested a direct patient or caregiver interaction with the device, as for the blood pressure and questionnaires inputted by the HPM for diet, activity and food intake monitoring. The no-silent data acquisition is particularly important for monitoring CDK patient lifestyle.

During the day there are several measureaments, with different time intervals and different frequencies; only one data transmission is done, if there is no worsening in patient parameters. For COPD patient all the data are collected in a silent mode from a wereable t-shirt and trasmitted to the PDA via Bluetooth; for CDK patient all the measurements, including a lifestyle questionnarie are stored in the HPM and trasmitted in silent mode to the PDA. PDA is in charge of doing the following action
- Collect all the data from the devices.

- Use a set of machine learning algorithms to determinate if it is needed to force a non scheduled trasmission to the Monitoring Framework.

- Trasmit the collected and analysed information to the Monitoring Framework and receive back the changes, that will affect the interaction between the patient and the other devices.

The Communication Framework is in charge of transmitting data among devices and from PDA to Central DB. This transmission is done using messages in a predefined xml format. The device that is in charge of doing the transmission of the xmls is the PDA.

The Monitor framework is the principal interface between the clinician and the patient. It receives data from the remote PDAs and it transmits back the therapy for food intake, drug intake, activities and scheduled measurements. The PDA is equipped also with a rule based decision support system, that contains an updatable set of rules created from the literature and validated by clinicians.

The rule based decision support system is in charge of analysing the data arrived from the PDAs and deciding if there is a grave or mild worsening of patient's conditions. It is also able to alert the clinician and propose the suggestions about the action to do in several cases. In the next section we will analyse the preprocessing phase needed to activate the intelligence in the PDA.

III. THE PDA CHRONIOUS PREPROCESSING PHASE
As we pointed out above, the Personal Digital Assistant is a smartphone equipped with WINDOWS MOBILE 6.5 Operating system, a SQL SERVER 2005 COMPACT database and a .NET FRAMEWORK 3.5. The data registered by the PDA are the following
- Data from the wereable jacket.

- Answers to questionnaries concerning dietary habits, drug intake and lifestyle of the patient.

- Data from the home patient monitor like blood pressure, glucometer measurements and body weight.

Once these data are collected they are saved to the PDA
database and a set of algorithms are triggered to analyse these data. Since the PDA analyzes data for two different diseases, two sets of different algorithms are used. The fundamental data needed by COPD treatment are ECG signals and Respiration data, so in case of a COPD patient we have a first processing Electrocardiogram Pre-processing. After that a Feature extraction phase is needed and at the end an Evaluation phase of the extracted features is done to determinate if an alert must be triggered to the Central System. For external devices used in particular by CDK patients, there is no need of a preprocessing phase beacuse foundamental measures are the ones provided by the glucometer, the weight scale and the blood pressure measure; so they are discrete time and directly used by the set of machine learning. Combined with these data, the answers to a set of queries concerning food intake, drug intake, lifestyle and mental status are passed to a set of machine learning algorithms to evaluate the whole patient condition. In next subsections we will analyse first the COPD set of algorithms used.

## A. Preprocessing Of Copd Signals

The aim of Preprocessing Phase is to improve the general quality of the ECG, for more accurate analysis and measurement, because there's the possibilty to have some noises on the signals. Possible noises in the signal include
- Low frequency Base Line Wandering (BW) caused by respiration and body movements.

- High frequency random noises caused by mains interference (50 or 60Hz).

- Muscular activity and random shifts of the ECG signal amplitude caused by poor electrode contact and body movements.

The preprocessing comprises:
- Removal of base line wandering. - Removal of high frequency noise. - QRS detection.

The BW which is is an extragenoeous low-frequency activity which may interfere with the signal analysis, rendering its clinical interpretation inaccurate and misleading. Two major techniques are employed for BW removal:
- Linear filtering: involves the design of a LTI high pass filter with cut off in way that the clinical information in the ECG is preserved and the BW is removed as much as possible.

- Polynomial fitting: includes the fitting of polynomials to representative points (knots) in the ECG, with one knot for each beat. Knots are selected from a silent segment, e.g. the PQ interval. A polynomial is fitted so that it passes through every knot in a smooth fashion.

The High Frequency Noise can be caused by the high frequency as well as power supply interference from the ECG
signal. It's removal is done using:
- The Daubechies (DB4) wavelet employed on the basis of the resemblance and similar frequency response