is unsatisfied and must make update decisions locally based solely on this knowledge.
Definition 4 (Decentralized CSP Solver): A decentralized
CSP solver is a CSP solver that for each variable xi, i ∈
{1*, . . . , N*}, must select its next value based only on an
evaluation of
$$\operatorname*{min}_{m\in{\mathcal{M}}_{i}}\Phi_{m}({\vec{x}}).$$
Φm(~x). (3)
That is, for each variable xithe solver must make a decision on the next value of xi based solely on knowing whether that variable is currently satisfied or not without explicitly knowing:
(D3) the assignments of other variables, xj for any j 6= i;
(D4) the set of clauses that any variable, including itself, participates in, Mj for j ∈ {1*, . . . , N*};
(D5) the functions that define clauses, Φm for m ∈
{1*, . . . , M*}.

Note that the properties (D1) (D2) of any CSP solver mean that a decentralized CSP solver must, without explicit communication, settle upon a satisfying assignment the first time one is found. Communication to co-ordinate global stopping or restarting of the solver would be contrary to the nature of the natural constraints of these problems and so is forbidden.

The stochastic algorithm we define in Section III shall provably satisfy the properties of a decentralized CSP solver with probability one. Moreover, it will also have the desirable property that it will automatically restart its search, without communication, upon any change to the clauses of a CSP that makes the current variable assignment no longer satisfying.

This is significant in practical applications as, for example, the arrival of new transmitters in a wireless network would induce a change the associated CSP.

## A. Formulating Wireless Network Tasks As Csps

Before proceeding, we demonstrate that several important resource allocation tasks in wireless networks fall within this CSP framework, which, therefore, provides a unifying framework for analyzing these tasks.

1) Graph colouring. As briefly described in Section I-A,
the channel assignment problem corresponds to decentralized graph colouring. In the simplest model, the network is described by an undirected interference graph G = (*V, E*) with vertices V and edges E. Each vertex represents a WLAN
and an edge exists between two WLANs if they interfere with each other when on the same channel. Define N = |V | and M = |E| and let D denote the set of available colours
(channels) and let xi be a variable with value equal to the colour selected by an intelligence co-located with each vertex i ∈ V . Each clause m ∈ {1*, . . . ,* |E|}, which is an enumeration of the elements of E, can be identified with an edge (*i, j*) ∈ E. We define

$\Phi_{m}(\vec{x})=\Phi_{m}(x_{i},x_{j})=\begin{cases}1&\text{if}x_{i}\neq x_{j}\\ 0&\text{otherwise.}\end{cases}$  cipation set, $\mathcal{M}_{i}$, of a variable $x_{i}$ consists of 
clauses where the vertex i is one end of the associated edge, Mi = {m ≡ (*i, j*) : (*i, j*) ∈ E} .

A variable assignment satisfies this CSP if and only if it is also a proper colouring for the graph G. Proper colourings correspond to channel assignments in which no two neighbouring WLANs in the interference graph have selected the same channel. To find a proper colouring, when one exists, a decentralized CSP solver requires only that an intelligence co-located with each vertex i can measure whether: (i) all of its neighbours are using a different colour from vertex i; or
(ii) at least one neighbour has selected the same colour as vertex i. This information is sufficient to evaluate eq. (3) and, in particular, the intelligence at each vertex does not need to know: (D3) the colour selected by any other vertex; (D4) its set of neighbours; or (D5) the exact nature of the clauses Φm, m ∈ {1*, . . . , M*}.

2) Channel assignment with channel-dependent interference. Whether or not transmitters interfere in the channel assignment task may depend on the radio channel selected.

This can arise due to frequency dependent radio propagation or to channel dependent spectral masks. That is, for regulatory reasons, different spectral masks are typically used when transmitting on channels at the edge and on channels in the middle of a radio band. This problem then has a collection of conflict graphs, one for each possible radio channel. This version of the channel assignment task can also be formulated as a CSP even though it is no longer a graph colouring problem. Let G(c) = (V, E(c)), c ∈ D be a set of undirected graphs with the same vertices V but possibly differing edge sets E(c). Again each vertex represents a WLAN, but the interference graph is channel-dependent. The Graph G(c) is associated with radio channel c and an edge exists in E(c) if two WLANs interfere while on channel c. Let xi be a variable with value equal to the channel selected by each vertex i ∈ V . Each clause m ∈ {1*, . . . ,* |E(1)| + *· · ·* + |E(D)|}, which is an enumeration of all edges in all graphs, can be identified with a c ∈ D and an edge (*i, j*) ∈ E(c) and is defined by

$$\Phi_{m}({\vec{x}})=\Phi_{m}(x_{i},x_{j})={\begin{cases}0&{\mathrm{if~}}x_{i}=x_{j}=c\\ 1&{\mathrm{~otherwise.}}\end{cases}}$$

The collection of clauses that variable xi, associated with vertex i, participates in can be identified as

$${\mathcal{M}}_{i}=\bigcup_{c\in{\mathcal{D}}}\left\{m\equiv(i,j,c):(i,j)\in E(c)\right\}.$$

With xi being the current channel selection of vertex i, for all c 6= xithe clauses associated with m ≡ (*i, j, c*) are automatically satisfied. Thus to evaluate eq. (3) it is sufficient for the station to measure if no neighbour coincides with its current channel selection or if at least one does. To find an interference-free channel assignment, a decentralized CSP
solver requires that each vertex i can measure whether: (i) all of its neighbours on the currently selected channel are using a different channel from itself; or (ii) at least one neighbour has selected the same channel.

3) Inter-session network coding. Network coding has been the subject of considerable interest in recent years as it offers the potential for significant increases in network capacity [9],
[10], [11]. In network coding, network elements combine packets together before transmission rather than forwarding 3