

![0_image_0.png](0_image_0.png)

tions required to find a satisfying assignment, whereupon the algorithm natural halts in a decentralized fashion. The median value is 21 iterations and the 95% centile is 98 iterations. Note that during this convergence period, although the network is operating sub-optimally, it does not cease to function. In a prototype lab set-up we have shown that a CFL update interval of less than 10 seconds is feasible on current hardware. Thus the median time to convergence is under 4 minutes. This is a reasonable time-frame for practical purposes, particularly as subparts of the network are functioning during this convergence period, and thus the CFL algorithm offers a pragmatic solution to this difficult decentralized CSP for which existing solvers could not be employed.

## Vi. Conclusions

We have shown that apparently distinct problems in networking can be placed within the framework of CSPs, where -
unlike with traditional motivating examples - the variables are co-located with devices that may not be able to communicate. We define the criteria that practical solvers must possess in order to be suitable for theses problems, labeling them decentralized CSP solvers.

As existing solvers fail to meet one or more of these criteria, we introduce a decentralized algorithm for solving CSPs. We prove that it will almost surely find a satisfying solution if one exists. In doing so, we generate bounds for the speed of convergence of the algorithm. We suspect, however, that our bounds for a general CSP are not tight and conjecture that the real bound should be closer to the one we have for the specific case of CSPs corresponding to graph coloring.

Given how much information decentralization is sacrificing, surprisingly an experimental investigation of solving random k-SAT instances suggests that the algorithm is competitive with two of the most promising centralized k-SAT solvers, WalkSAT and Survey Propagation, on instances of random kSAT with order one thousand variables. This raises the question: what is the performance cost of decentralized operation?

This is particularly pertinent as the decentralized nature of the CFL algorithm lends itself to parallelized computation as it has a small, fixed memory requirement per variable, making it suitable for use in circumstances where a centralized algorithm could also be used but would be difficult to implement in a distributed fashion.

## Appendix

For each i ∈ {1*, . . . , N*} let ~pi(t) ∈ [0, 1]D, t ∈ N, be the CFL probability vector for variable i at time t and xi(t)
be the variable's value selected stochastically from ~pi(t). Let P(t) = (~p1(t)*, . . . , ~p*N (t)) and X(t) = (x1(t)*, . . . , x*N (t))
record the overall state of the CSP-CFL system.

The state of the probability vectors {P(t)} forms a Markov Chain, or Iterated Function System, with place dependent probabilities [38]. The convergence time of the algorithm is the first time the chain enters an absorbing state representing a valid solution to the CSP. The absorbing states are identifiable in terms of the variable values {X(t)}:

$$A=\bigcup\left\{{\vec{x}}:\Phi_{m}({\vec{x}})=1{\mathrm{~for~all~}}m\in{\mathcal{M}}\right\},$$

as if X(t) ∈ A, then P(t+ 1) = (δx1
, . . . , δxN ) so that X(t+
1) = X(t) almost surely and hence a solution to the CSP has been found. The algorithm's stopping time is

$$\tau:=\operatorname*{inf}_{t\geq0}\left\{X(t)\in A\right\}.$$

Define γ = min(*a, b*)/(D − 1 + a/b) and let S be the set of states such that for all i ∈ N either pi = δk for some k ∈ {1, · · · , D} or (pi)k ≥ γ for all k ∈ {1, · · · , M}. The next lemma is obvious.

Lemma 1: For any integer t ≥ 0, P(t) ∈ S.

Theorem 1: The method of proof for both statements is similar: we create a sequence of events over N − 1 iterations that, regardless of the initial configuration, lead to a satisfying assignment with a probability that we find a lower bound for. Due to the Markovian nature of the algorithm and the independence of the probability of this event on its initial conditions, if this event does not occur in N − 1 iterations, it has the same probability of occurring in the next N − 1 iterations. This is what leads to the geometric nature of the bounds. The difference between a general CSP and those corresponding to coloring is that for the latter the variables are ensured to experience fewer dissatisfaction events before finding a satisfying assignment.

First consider a general CSP. Select an arbitrary valid solution ~a ∈ A with components (~a)i. For each m ∈ M
define Nm to be the variables that participate in clause m.

For each t ≥ 0, define the set of unsatisfied variables at time t by

$$U_{t}:=\bigcup_{m\in{\mathcal{M}}}\left\{{\mathcal{N}}_{m}:\Phi_{m}(X(t))=0\right\}$$

and the number of unsatisfied variables to be nt = |Ut|. At time 0 assume X(0) = ~x(0), some ~x(0). If U0 = ∅ then X(0) ∈ A, the algorithm has found a solution and τ = 0. If