# Cost Based Satisficing Search Considered Harmful

William Cushing and **J. Benton** and **Subbarao Kambhampati**∗
Dept. of Comp. Sci. and Eng.

Arizona State University Tempe, AZ 85281

## Abstract

Recently, several researchers have found that cost-based satisficing search with A* often runs into problems. Although some "work arounds" have been proposed to ameliorate the problem, there has not been any concerted effort to pinpoint its origin. In this paper, we argue that the origins can be traced back to the wide variance in action costs that is observed in most planning domains. We show that such cost variance misleads A* search, and that this is no trifling detail or accidental phenomenon, but a systemic weakness of the very concept of "cost-based evaluation functions + systematic search + combinatorial graphs". We show that satisficing search with sized-based evaluation functions is largely immune to this problem.

## 1 Introduction

Much of the scale-up, as well as the research focus, in the automated planning community in the recent years has been on satisficing planning. Unfortunately, there hasn't been a concomitant increase in our understanding of satisficing search. Too often, the "theory" of satisficing search defaults to doing A* with inadmissible heuristics. While removing the requirement of admissible heuristics certainly relaxes the guarantee of optimality, there is no implied guarantee of efficiency. A combinatorial search can be seen to consist of two parts: a "discovery" part where the (optimal) solution is found and a "proof" part where the optimality of the solution is verified. While an optimizing search depends crucially on both these phases, a satisficing search is instead affected more directly by the discovery phase. Now, standard A* search conflates the discovery and proof phases together and terminates only when it picks the optimal path for expansion. By default, satisficing planners use the same search regime, but relax the admissibility requirement on the heuristics. This may not cause too much of a problem in domains with uniform action costs, but when actions can have non-uniform costs, the the optimal and second optimal solution can be arbitrarily apart in depth. Consequently, A*
search with cost-based evaluation functions can be an arbitrarily bad strategy for satisficing search, as it waits until the solution is both discovered and proved to be optimal.

∗An extended abstract of this paper appeared in the proceedings of SOCS 2010. This research is supported in part by ONR
grants N00014-09-1- 0017 and N00014-07-1-1049, and the NSF grant IIS-0905672.

To be more specific, consider a planning problem for which the cost-optimal and second-best solution to a problem exist on 10 and 1000 unspecified actions. *The optimal* solution may be the larger one. How long should it take just to find the 10 action plan? How long should it take to prove (or disprove) its optimality? In general (presuming PSPACE/EXPSPACE 6= P):
1. Discovery should require time exponential in, at most, 10.

2. Proof should require time exponential in, at least, 1000.

That is, in principle, the only way to (domain-independently) prove that the 10 action plan is better or worse than the 1000 action one is to in fact go and discover the 1000 action plan.

Thus, A* search with cost-based evaluation function will take time proportional to b 1000 for either discovery or proof.

Using both abstract and benchmark problems, we will demonstrate that this is a systematic weakness of any search that uses cost-based evaluation function. In particular, we shall see that if ε is the smallest cost action (after all costs are normalized so the maximal cost action costs 1 unit), then the time taken to discover a depth d optimal solution will be b d ε . If all actions have same cost, then ε ≈ 1 where as if the actions have significant cost variance, then ε  1. We shall see that for a variety of reasons, most real-world planning domains do exhibit high cost variance, thus presenting an "ε*-cost trap*" that forces any cost-based satisficing search to dig its own ( 1 ε deep) grave.

Consequently, we argue that satisficing search should resist the temptation to directly use cost-based evaluation functions (i.e., f functions that return answers in cost units)
even if they are interested in the quality (cost measure) of the resulting plan. We will consider two size-based branchand-bound alternatives: the straightforward one which completely ignores costs and sticks to a purely size-based evaluation function, and a more subtle one that uses a cost-sensitive size-based evaluation function (specifically, the heuristic returns the size of the cheapest cost path; see Section 2). We show that both of these outperform cost-based evaluation functions in the presence of ε-cost traps, with the second one providing better quality plans (for the same run time limits)
than the first in our empirical studies.

While some of the problems with cost-based satisficing search have also been observed, in passing, by other researchers (e.g. (Benton et al. 2010; Richter and Westphal 2010), and some work-arounds have been suggested, our