explored, under fc, to at least depth ec · 5000 before x is found (and at most depth ec ·
1 ε
). Under ˆfs, we have instead exploration up to at least depth es ·
1 2 and at most depth es ·
1 1
.

As 5000 objects is already far above the capabilities of any current domain-independent planners, we can say that at most plane-shuffling states considered, cost-based search exhausts the entire associated passenger-shuffling space during backtracking. That is, it stops exploring the space due to exhausting finite possibilities, rather than by adding up sufficiently many instances of 2ε increases in f - the result is the same as if the cost of passenger movement was 0. Worse, such exhaustion commences immediately upon backtracking for the first time (with admissible heuristics). Unless *very* inadmissible (large heuristic weights), then even with inadmissible heuristics, still systematic search should easily get trapped on cost plateaus - before finding a solution.

In contrast, size-based search will be exhausting only those passenger assignments differing in at most es values; in the *worst* case this is equivalent to the cost-based method, but for good heuristics is a notable improvement. (In addition the size-based search will be exploring the planeshuffling space deeper, but that space is [assumed to be]
much smaller than any single passenger-shuffling space.)
Then it is likely the case that cost-based search dies before reporting a solution while size-based search manages to find one or more.

## A.2 Analyzing Lama'S Performance

While LAMA-size out-performs LAMA, it is hardly as dramatic a difference as predicted above. Here we analyze the results in greater depth, in an attempt to understand how LAMA avoids being immediately trapped by the passengershuffling spaces. Our best, but not intuitive, explanation is its pessimistic delayed evaluation leads to a temporary sort of depth-first bias, allowing it to skip exhaustion of many of the passenger-shuffling spaces until *after* finding a solution.

So, (quite) roughly, LAMA is able to find one solution, but not two. Landmarks. The passenger-shuffling subspaces are search plateaus, so, the most immediate hypothesis is that LAMA's use of landmarks helps it realize the futility of large portions of such plateaus (i.e., by pruning them). However, LAMA
uses landmarks only as a heuristic, and in particular uses them to order an additional (also cost-based) open list (taking every other expansion from that list), and the end result is actually greater breadth of exploration, not greater pruning.

Multiple Open Lists. Then an alternative hypothesis is that LAMA avoids immediate death by virtue of this additional exploration, i.e., one open list may be stuck on an enormous search plateau, but if the other still has guidance then potentially LAMA can find solutions due to the secondary list. In fact, the lists interact in a complex way so that conceivably the multiple-list approach even allows LAMA to
'tunnel' out of search plateaus (in either list, so long as the search plateaus do not coincide). Indeed the secondary list improves performance, but turning it off still does not cripple LAMA, let alone outright kill it.

Small Instances. It is illuminating to consider the behavior of LAMA and LAMA-size with only 4 passengers total; here the problem is small enough that optimality can be proved.

LAMA-size terminates in about 12 minutes. LAMA terminates in about 14.5 minutes. Of course the vast majority of time is spent in the last iteration (with heuristic weight 1 and all actions considered) - and both are unrolling the exact same portion of state space (which is partially verifiable by noting that it reports the same number of unique states in both modes). There is only one way that such a result is at all possible: the cost-based search is re-expanding many more states. That is difficult to believe; if anything it is the sizebased approach that should be finding a greater number of suboptimal paths before hitting upon the cheapest. The explanation is two-fold. First of all pessimistic delayed evaluation leads to a curious sort of depth-first behavior. Secondly, cost-based search pays far more dearly for failing to find the cheapest path first.

Delayed Evaluation. LAMA's delayed evaluation is not equivalent to just pushing the original search evaluation function down one level. This is because it is the *heuristic* which is delayed, not the full evaluation function. LAMA's evaluation function is the sum of the *parent's* heuristic on cost-to-go and the *child's* cost-to-reach: fL(n) = g(n) +
h(*n.p.v*). One can view this technique, then, as a transformation of the original heuristic. Crucially, the technique increases the inconsistency of the heuristic. Consider an optimal path and the perfect heuristic. Under delayed evaluation of the perfect heuristic, each sub-path has an fL-value in excess of f
∗ by exactly the cost of the last edge. So a high cost edge followed by a low cost edge demonstrates the nonmonotonicity of fL induced by the inconsistency wrought by delayed evaluation. The problem with non-monotonic evaluation functions is not the decreases *per se*, but the increases that precede them. In this case, a low cost edge followed by a high cost edge along an optimal path *induces backtracking* despite the perfection of the heuristic prior to being delayed.

Depth-first Bias. Consider some parent n and two children x and y (x.p = n, y.p = n) with x reached by some cheap action and y reached by some expensive action. Observe that siblings are always expanded in order of their cost-to-reach
(as they share the same heuristic value), so x is expanded before y. Now, delaying evaluation of the heuristic was pessimistic: h(x.v) was taken to be h(n.v), so that it appears that x makes no progress relative to n. Suppose the pessimism was unwarranted, for argument's sake, say entirely unwarranted: h(x.v) = h(n.v) − c(x.o). Then consider a cheap child of x, say w. We have:

$$f_{L}(w)=g(w)+h(x.v),$$ $$=g(x)+c(w.o)+h(n.v)-c(x.o),$$ $$=f_{L}(x)-c(x.o)+c(w.o),$$ $$=f(n)+c(w.o),$$
(5)
so in particular, fL(w) < fL(y) because f(n) + c(w.o) <
f(n) + c(y.o). Again suppose that w makes full progress towards the goal (the pessimism was entirely unwarranted),
so h(w.v) = h(x.v) − c(w.o). So any of its cheap children,