say $ z$, satisfies: . 
$$f_{L}(z)=g(w)+c(z.o)+h(x.v)-c(w.o),\tag{6}$$ $$=f_{L}(w)-c(w.o)+c(z.o),$$ (7) $$=f_{L}(x)-c(x.o)+c(w.o)-c(w.o)+c(z.o),$$ (8) $$=f_{L}(x)-c(x.o)+c(z.o),$$ (9) $$=f(n)+c(z.o).\tag{10}$$
Inductively, any low-cost-reachable descendant, say x 0, that makes full heuristic progress, has an fL value of the form f(n)+c(x 0.o), and in particular, fL(x 0) < fL(y), that is, all such descendants are expanded prior to y. Generalizing, any low-cost-reachable and not heuristically bad descendant of x is expanded prior to y (where the bound on heuristic badness is c(y.o) - the amount by which y is pessimistically considered heuristically bad). Once y itself is finally expanded, then its descendants can compete with the descendants of x on even footing, so in particular some of the expensive exits of the low-cost subspace underneath y may very well be explored prior to some of the expensive (heuristically or immediately) exits of the low-cost subspace underneath x —
in contrast with the low-cost subspaces themselves, which were explored in depth-first fashion, i.e., all of x's subspace before all of y's subspace.

Then LAMA exhibits a curious, temporary, depth-first behavior initially, but in the large exhibits the normal breadthfirst bias of systematic search. Depth-first behavior certainly results in finding an increasingly good sequence of plans to the same state: At every point in the best plan to some state where a less-expensive sibling leads to a slightly worse plan to the same state is a point at which depth-first behavior finds worse plans first. The travel domain is very strongly connected, so there are many such opportunities.

Overhead. Consider two paths to the same plane-shuffling state, the second one actually (but not heuristically) better. Then LAMA has already expanded the vast majority, if not the entirety, of the associated passenger-shuffling subspace before finding the second plan. That entire set is then re-expanded. The size-based approach is not compelled to exhaust the passenger-shuffling subspaces in the first place (indeed, it is compelled to backtrack to other possibilities), and so in the same situation ends up performing less re-expansion work within each passenger-shuffling subspace. Then even if the size-based approach is overall making more mistakes in its use of planes (finding worse plans first), which is to be expected, the price per such mistake is notably smaller.

| Domain      | LAMA   | LAMA-size   |
|-------------|--------|-------------|
| Rendezvous  | 70.8%  | 83.0%       |
| Elevators   | 79.2%  | 93.6%       |
| Woodworking | 76.6%  | 64.1%       |

![0_image_0.png](0_image_0.png)

Table 3: IPC metric on LAMA variants.

Results.9 With more than about 8 total passengers, LAMA
is unable to complete any search stage except the first (the 9New best plans for Elevators were found (largely by LAMAsize). The baseline planner's score is 71.8% against the better reference plans.

greedy search). For the same problems, LAMA-size finds the same first plan (the heuristic values differ, but not the structure), but is then subsequently able to complete further stages of search. In so doing it sees marked improvement in cost; on the larger problems this is due only to finding better variants on the greedy plan. Other domains are included for broader perspective, woodworking in particular was chosen as a likely counter-example, as all the actions concern just one type of physical object and the costs are not wildly different. For the same reasons we would expect LAMA to out-perform LAMA-size in some cost-enhanced version of Blocksworld. For a comprehensive empirical analysis, see (Richter and Westphal 2010). Summary. LAMA is out-performed by LAMA-size, due to the former spending far too much time expanding and reexpanding states in the ε-cost plateaus. It fails in "depthfirst" mode: finding not-cheapest almost-solutions, exhausting the associated cheap subspace, backtracking, finding a better path to the same state, re-exhausting that subspace,
. . . , in particular exhausting memory extremely slowly (it spends all of its time re-exhausting the *same* subspaces).

## A.3 Analyzing The Performance Of Sapareplan

The contrasting failure mode, "breadth-first", is characterized by exhausting each such subspace as soon as it is encountered, thereby rapidly exhausting memory, without ever finding solutions. This is largely the behavior of SapaReplan (which does eager evaluation), with cost-based methods running out of memory (much sooner than the deadline, 30 minutes) and size-based methods running out of time. So for SapaReplan it is the size-based methods that are performing many more re-expansions, as in a much greater amount of time they are failing to run out of memory. From the results, these re-expansions must be in a useful area of the search space.

In particular it seems that the cost-based methods must indeed be exhausting the passenger-shuffling spaces more or less as soon as they are encountered - as otherwise it would be impossible to both consume all of memory yet fail to find better solutions. (Even with fuel there are simply too few distinct states modulo passenger-shuffling.) However, they do find solutions before getting trapped, in contradiction with theory.

The explanation is just that the cost-based methods are run with large (5) heuristic weight, thereby introducing significant depth-first bias (but not nearly so significant as with pessimistic delayed evaluation), so that it is possible for them to find a solution before attempting to exhaust such subspaces.

It follows that they find solutions within seconds, and then spend minutes exhausting memory (and indeed that is what occurs). The size-based methods are run with small heuristic weight (2) as they tend to perform better in the long run that way. It would be more natural to use the same heuristic weight for both types, but, the cost-based approaches do conform to theory with small heuristic weights - producing no solutions, hardly an interesting comparison.

A.4 Summary Both planners are capable of finding solutions to problems in the travel domain despite the use of a cost-based evaluation function by using various tricks to induce a limited