order of their upper bounds. When processing a variable Xj , j /∈ S(i), we assign Xj to the smallest value that has not been taken. When processing a variable Xj , j ∈ S(i), we store information about the number of successors that we have seen so far. We perform pruning if we find an interval [*l, u*] such that the number of available values in this interval equals the number of successors in the interval [1, u]. We use a disjoint set data structure to perform counting operations in O(d) time.

Algorithm 1 shows a pseudocode of our algorithm. We denote T a disjoint set data structure. The function F ind(v1, T) returns the set that contains the value v1. The function Union(v1, v2, T) joins the values v1 and v2 into a single set. We use a disjoint set union data structure [22] that allows to perform *F ind* and *Union* in O(1) time.

Theorem 1 *Algorithm 1 enforces conditions* (5)–(7) in O(nd) *time.* Proof: Enforcing conditions (5)–(7) on the ith variable corresponds to the ith loop
(line 2). Hence, we can consider each run independently.

We denote Ij a set of values that are taken by non-successors of Xi after the variable Xj is processed. The algorithm maintains a pointer b that stores the minimum value such that the number of available values in the interval [b, max(Xj ) + 1) is equal to Bi1*,max*(Xj )
after the variable Xj is processed.

Invariant. We prove the invariant for the pointer b by induction. The invariant holds at step j = 0. Note that the first variable can not be a successor of Xi. Indeed, b = max(X1) + 1 and the interval [max(X1) + 1, max(X1) + 1) is empty. Let us assume that the invariant holds after processing the variable Xj−1.

Suppose the next variable to process is Xj . After we assigned Xj to a value, we move b forward to capture a possible increase of the upper bound from max(Xj−1) to max(Xj ) (line 13) and, then, backward if either Xj is a successor of Xi or Xj is a non-successor and Xj takes a value v such that b ≤ v (line 15). Note, that when we move b, we ignore values in Ij . To point this out we call steps of b available-value-steps. Thanks to a disjoint set union data structure we can jump over values in Ij in O(1) per step [22].

Moving forward. We move the pointer b on max(Xj ) − max(Xj−1) availablevalue-steps forward. We denote b 0a new value of b. The line 13 ensures that the number of available values in the interval [b 0, max(Xj ) + 1) equals to the number of available values in the interval [b, max(Xj−1) + 1). This operation preserves the invariant by the induction hypothesis.

Moving backward. We consider two cases.

Case 1. Xj is a successor of Xi. In this case, we move b 0 one available-value-step backward to capture that Xj is a successor (line 15). This preserves the invariant.

Case 2. Xj is not a successor of Xi. Suppose v and b 0are in the same set, so that F ind(*v, T*) = F ind(*b, T*). Then we move b 0to the minimum element in this set. This step does not change the number of available values between the pointer b 0 and max(Xj ). However, it makes sure that b 0stores the minimum possible value. This preserves the invariant.

Suppose v and b 0are in different sets. If *v > b*0then we move b 0 one availablevalue-step backward, as v took one of the available values in [b 0, max(Xj ) + 1). This preserves the invariant. If *v < b*0then the invariant holds by the induction hypothesis.

Hence, the new value of b preserves the invariant.