CUMULATIVE and precedence constraints [11, 12]. Reasoning about such combinations of global constraints may achieve additional pruning. In this work we propose an efficient propagation algorithm for the ALLDIFFPREC constraint. However, we also prove that propagating the constraint *completely* is computationally intractable.

## 2 Formal Background

A constraint satisfaction problem (CSP) consists of a set of variables, each with a domain of possible values, and a set of constraints specifying allowed values for subsets of variables. A solution is an assignment of values to the variables satisfying the constraints. We write D(X) for the domain of the variable X. Domains can be ordered
(e.g. integers). In this case, we write min(X) and max(X) for the minimum and maximum elements in D(X). The *scope* of a constraint is the set of variables to which it is applied. A *global constraint* is one in which the number of variables is not fixed. For instance, the global constraint ALLDIFFERENT([X1*, . . . , X*n]) ensures Xi 6= Xj for 1 ≤ *i < j* ≤ n. By comparison, the binary constraint, Xi 6= Xj is not global.

When solving a CSP, we often use propagation algorithms to prune the search space by enforcing properties like domain, bounds or range consistency. A *support* on a constraint C is an assignment of all variables in the scope of C to values in their domain such that C is satisfied. A variable-value Xi = v is *consistent* on C iff it belongs to a support of C. A constraint C is *domain consistent* (DC) iff every value in the domain of every variable in the scope of C is consistent on C. A *bound support* on C is an assignment of all variables in the scope of C to values between their minimum and maximum values (respectively called lower and upper bound) such that C is satisfied. A
variable-value Xi = v is *bounds consistent* on C iff it belongs to a bound support of C.

A constraint C is *bounds consistent* (BC) iff the lower and upper bounds of every variable in the scope of C are bounds consistent on C. Range consistency is stronger than BC but is weaker than DC. A constraint C is *range consistent* (RC) iff iff every value in the domain of every variable in the scope of C is bounds consistent on C. A CSP
is DC/RC/BC iff each constraint is DC/RC/BC. Generic algorithms exists for enforcing such local consistency properties. For global constraints like ALLDIFFERENT,
specialized methods have also been developed which offer computational efficiencies.

For example, a bounds consistency propagator for ALLDIFFERENT is based on the notion of Hall interval. A Hall interval is an interval of h domain values that completely contains the domains of h variables. Clearly, variables whose domains are contained within the Hall interval consume all the values in the Hall interval, whilst any other variables must find their support outside the Hall interval.

We will compare local consistency properties applied to logically equivalent constraints. As in [13], we say that a local consistency property Φ on the set of constraints S is *stronger* than Ψ on the logically equivalent set T iff, given any domains, Φ removes all values Ψ removes, and sometimes more. For example, domain consistency on ALLDIFFERENT([X1*, . . . , X*n]) is stronger than domain consistency on
{Xi 6= Xj | 1 ≤ *i < j* ≤ n}. In other words, decomposition of the global ALLDIFFERENT constraint into binary not-equals constraints hinders propagation.