our argument easier. First, we need to preprocess variables domains so that they respect the precedence constraints Xi < Xj , (*i, j*) ∈ E: min(Xi) < min(Xj ) and max(Xi) < max(Xj ). However, we notice that it is sufficient to enforce a weaker condition on bounds of variables Xi and Xj such that min(Xi) ≤ min(Xj ) and max(Xi) ≤ max(Xj ). If these conditions on variables domains are satisfied then we say that domains are *preprocessed*. Second, we construct a satisfying assignment as follows. We process all values in the increasing order. When processing a value v, we assign v to the variable with the smallest upper bound, u that has not yet been assigned and that contains v in its domain. Suppose, there exists a set of variables that have the upper bound u, so that X0 = {Xi| D(Xi) = [*v, u*]}. To construct a solution for ALLDIFFERENT, we would break these ties arbitrarily. In this case, however, we select a variable that is not successor of any variable in the set X0. Such a variable always exists, as the transitive closure of the precedence graph does not contain cycles. By the correctness of the original algorithm the resulting assignment is a solution. In addition to satisfying the ALLDIFFERENT constraint, this solution also satisfies the precedence constraints. Indeed, for the constraint Xi < Xj , the upper bound of D(Xi) is necessarily smaller than or equal to the upper bound of D(Xj ). In the case of equality, we tie break in favor of Xi. Therefore, a value is assigned to Xi before a value gets assigned to Xj . Since we process values in increasing order, we obtain Xi < Xj as required.

Example 1 *Consider* ALLDIFFPREC([X1, X2, X3, X4], {(1, 3),(2, 3),(1, 4),(2, 4)}) with D(X1) = D(X2) = {1, 2, 3, 4, 5}, D(X3) = {1, 2, 3} and D(X4) = {2, 3, 4}.

First, we preprocess domains to ensure that min(Xi) ≤ min(Xj ) and max(Xi) ≤
max(Xj ), i ∈ {1, 2}, j ∈ {3, 4}*. This gives* D(X1) = D(X2) = D(X3) = {1, 2, 3},
D(X4) = {2, 3, 4}. As in the greedy algorithm, we consider the first value 1. This value is contained in domains of variables X1, X2 and X3*. As* max(X1) = max(X2) = max(X3) = 3*, by tie breaking we select variables that are not successors of any* other variables among variables {X1, X2, X3}. There are two such variables: X1 and X2. We break this tie arbitrarily and set X1 *to 1. The new domains are* D(X1) = 1, D(X2) = D(X3) = {2, 3}, D(X4) = {2, 3, 4}. The next value we consider is 2. Again, there exist two variables that contain this value, and they have the same upper bounds.

By tie-breaking, we select X2. Finally, we assign X3 and X4 *to 3 and 4 respectively.*
We can design a filtering algorithm based on this satisfiability test. By successively reducing a variable domain in halves with a binary search we can filter the lower and upper bounds of a variable domain with O(logd) tests where d is the cardinality of the domain. Consider, for example, a variable X with the domain D(X) = [*l, u*]. We are looking for a support for min(X). At the first step we temporally fix the domain of X to the first half so that D(X) = [l,(u − l)/2] and run the bounds disentailment detection algorithm. If this algorithm fails, we halved the search and repeat with the other half.

If this algorithm does not fail, we know that there is a value in [l,(u − l)/2] that has a bounds support. Hence, we continue with the binary search within this half. As each test takes O(n) time and there are n variables to prune, the total running time is O(n 2logd).

In the rest of this paper, we improve on this using sophisticated algorithmic ideas.