# A Goal-Directed Implementation Of Query Answering For Hybrid Mknf Knowledge Bases

Ana Sofia Gomes, Jos´e J´ulio Alferes and Terrance Swift CENTRIA, Departamento de Inform´atica Faculdade Ciˆencias e Tecnologias Universidade Nova de Lisboa 2829-516 Caparica, Portugal submitted 1 June 2010; revised 18 October 2010; accepted 25 July 2012

## Abstract

Ontologies and rules are usually loosely coupled in knowledge representation formalisms.

In fact, ontologies use open-world reasoning while the leading semantics for rules use non-monotonic, closed-world reasoning. One exception is the tightly-coupled framework of Minimal Knowledge and Negation as Failure (MKNF), which allows statements about individuals to be jointly derived via entailment from an ontology and inferences from rules.

Nonetheless, the practical usefulness of MKNF has not always been clear, although recent work has formalized a general resolution-based method for querying MKNF when rules are taken to have the well-founded semantics, and the ontology is modeled by a general oracle. That work leaves open what algorithms should be used to relate the entailments of the ontology and the inferences of rules. In this paper we provide such algorithms, and describe the implementation of a query-driven system, *CDF-Rules*, for hybrid knowledge bases combining both (non-monotonic) rules under the well-founded semantics and a (monotonic) ontology, represented by a CDF Type-1 (**ALCQ**) theory.

KEYWORDS: Knowledge representation, well-founded semantics, description logics, implementation.

## 1 Introduction

Ontologies and rules offer distinctive strengths for the representation and transmission of knowledge over the Semantic Web. Ontologies offer the deductive advantages of first-order logics with an open domain, while guaranteeing decidability.

Rules employ non-monotonic (closed-world) reasoning that can formalize scenarios under locally incomplete knowledge; rules also offer the ability to reason about fixed points (e.g. reachability) which cannot be expressed within first-order logic.

## Example 1

Consider a scenario application for a Customs Agency where an ontology is used to assess and classify aspects of imports and exports. An ontology with such characteristics would embrace several thousand axioms. In these axioms, as an example, arXiv:1103.3949v2 [cs.AI] 1 Nov 2012